import java.util.*;

/** Generic searching and sorting methods */
public class Generics {
    
    /** = v is one of the items enumerated by b. 
     The Objects must implement Comparable */
    public static boolean linearSearch(Iterator b, Object v) {
        while (b.hasNext()) {
            if (((Comparable) b.next()).compareTo(v) == 0)
                return true;
        }
        return false;
    }
    
    /** = the maximum of the items enumerated by b, using the comparison
     given by Comparable, which must be implemented by the items
     Throw a RuntimeException if there are no items to enumerate*/
    public static Object max(Iterator b) {
        if (!b.hasNext())
            throw new RuntimeException("Can't get max of empty enumeration");
        Comparable res= (Comparable) (b.next());
        // invariant: res is the max of all items enumerated thus far
        while (b.hasNext()) {
            Comparable d= (Comparable) (b.next());
            if (d.compareTo(res) > 0)
                res= d;
        }
        
        return res;   
    }
    
    /** = the minimum of the items enumerated by b, using the comparison
     given by Comparable, which must be implemented by the items
     Throw a RuntimeException if there are no items to enumerate*/
    public static Object min(Iterator b) {
        if (!b.hasNext())
            throw new RuntimeException("Can't get max of empty enumeration");
        Comparable res= (Comparable) (b.next());
        // invariant: res is the max of all items enumerated thus far
        while (b.hasNext()) {
            Comparable d= (Comparable) (b.next());
            if (d.compareTo(res) < 0)
                res= d;
        }
        
        return res;   
    }
    
    /** = "v occurs in enumeration it" */
    public static boolean isIn(Iterator it, Object v) {
        while (it.hasNext()) {
            if (  ((Comparable)(it.next())).compareTo(v) == 0)
                return true; 
        }
        return false;  
    }
    
}