import java.util.*;

/** An enumerator for the letters in a String */
public class LetterEnum implements Iterator {
    
    private String s; /** The String who letters are to be enumerated*/
    private int k;    /** letters in s[k..] remain to be enumerated
                  Calling hasNext sets it to index of next
                  letter, if there is one, or to s.length().*/
    
    /** Constructor: an enumerator for the
        letters in s  */
    public LetterEnum(String s) {
        this.s= s;
        k= 0;
    }
    
    /** = "there is another item to enumerate" */
    public boolean hasNext() {
        while (k != s.length() && 
               !Character.isLetter(s.charAt(k))) {
           k= k+1;
        }
        return k < s.length();
    }
    
    /** = the next item to enumerate. Throw a
          NoSuchElementException if there is none.*/
    public Object next() {
        if (!hasNext())
        return new NoSuchElementException();
        k= k+1;
        return new Character(s.charAt(k-1));
    }
    
    /** not implemented */
    public void remove() {}
    
    
    
}