import java.util.*;

/** An enumerator for the evens in h..k */
public class EvensEnum implements Iterator {
    
    private int item; /** next even integer to enumerate (if <= k)*/
    private int k;    /** enumerate the evens <= k
    
    /** Constructor: an enumerator for the
        evens in h..k  */
    public EvensEnum(int h, int k) {
        this.k= k;
        if (h % 2 == 0) item= h;
        else item= h+1;
    }
    
    /** = "there is another item to enumerate" */
    public boolean hasNext() {
        return item <= k;
    }
    
    /** = the next item to enumerate. Throw a
          NoSuchElementException if there is none.*/
    public Object next() {
        if (item > k) 
            throw new NoSuchElementException();
        int r= item;
        item= item + 2;
        return new Integer(r);
    }
    
    /** not implemented */
    public void remove() {}
    
}