public class ListSeqStructure implements SeqStructure
{
	// acts as a queue first in first out
	int size;
	ListCell head;
	ListCell tail;
	
	public ListSeqStructure()
	{
		size = 0;
		head = null;
		tail = null;
	}
	
	// inserts at tail
	public void put(Object o)
	{
		ListCell temp = new ListCell(o, null);
		// first insert
		if(tail == null)
		{
			head = temp;
			tail = temp;
			size++;
			return;
		}
		tail.setNext(temp);
		tail = temp;
		size++;
	}
	
	// gets the head
	public Object get()
	{
		if(head == null)
			return null;
		Object datum = head.getDatum();
		head = head.getNext();
		// removed the only element
		if(head == null)
			tail = null;
		size--;
		return datum;
	}
	
	// returns if the Seq is empty
	public boolean isEmpty()
	{
		return (size == 0);
	}
	
	// return the size
	public int size()
	{
		return size;
	}
}