public class ListSearchStructure implements SearchStructure
  // a list in decreasing order
{
	int size;
	ListCell head;
	
	public ListSearchStructure()
	{
		size = 0;
		head = null;
	}

	// inserts o into list in decreasing order
	public void insert(Object o)
	{
		ListCell temp = new ListCell(o, null);
		if(head == null)
		{
			head = temp;
			size++;
			return;
		}
		// a pointer and trailing pointer to find where to insert into list
		ListCell p, tp;
		tp = null;
		p = head;
		while(p != null && ( (Comparable)p.getDatum() ).compareTo(o) > 0)
		{
			tp = p;
			p = p.getNext();
		}
		// new head of list
		if(tp == null)
		{
			temp.setNext(head);
			head = temp;
			size++;
			return;
		}
		// normal insert inbetween tp and p
		tp.setNext(temp);
		temp.setNext(p);
		size++;
	}
	
	// delete all occurances of objects equal to o
	public void delete(Object o)
	{
		while(helperDel(o));
	}
	
	// helper Del method to delete all occurances
	private boolean helperDel(Object o)
	{
		if(head == null)
			return false;
		// a pointer and trailing pointer to find object to delete
		ListCell p, tp;
		tp = null;
		p = head;
		while( p != null && ( (Comparable)p.getDatum() ).compareTo(o) != 0 )
		{
			tp = p;
			p = p.getNext();
		}
		// removing head of list
		if(tp == null)
		{
			head = head.getNext();
			size--;
			return true;
		}
		// if p is null did not find o
		if(p == null)
			return false;
		// p is what we want to delete
		tp.setNext(p.getNext());
		size--;
		return true;
	}
	
	// search for object o
	public boolean search(Object o)
	{
		if(head == null)
			return false;
		// pointer to traverse the list
		ListCell p = head;
	         
		while( p != null && ( (Comparable)p.getDatum() ).compareTo(o) > 0 )
			p = p.getNext();
		// if p is null not found else found
		if(p == null || ((Comparable)p.getDatum() ).compareTo(o) < 0 )
			return false;
		else
			return true;
	}
	
	// return the size
	public int size()
	{
		return this.size;
	}
}
