public abstract class TestThread extends Thread {
	
	protected int points=0;
	protected boolean done=false;
	protected boolean hadException=false;
	protected Exception exception=null;
	
	/*
	 * test -
	 * This method should run the test adding points to the member variable
	 * points.
	 *
 	 * Note: It should throw all uncaught exceptions (ie use the throws clause)
	 */
	abstract void test() throws Exception;
	
	/*
	 * printDescription -
	 * This method should simply print out a description of the test to
	 * the screen.
	 */
	abstract void printDescription();
	
	public void run() {
		try {
			test();
		}
		catch (Exception e) {
			hadException=true;
			exception=e;
		}
		done=true;
	}
	
	public Exception getException() {
		return exception;
	}
	
	public boolean isDone() {
		return done;
	}
	
	public int getPoints() {
		return points;	
	}
	
	public boolean hadException() {
		return hadException;
	}
}