import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

public class TestBed {

		
	public static void main(String[] args) {
		BufferedReader reader=null;
		
		//If not enough parameters, display usage and exit
		if (args.length<1) {
			System.out.println("Usage: java TestBed <filename>");
			System.exit(1);
		}
		
		//Open a reader to read in the class names
		try {
			reader=new BufferedReader(new FileReader(args[0]));
		}
		catch (IOException e) {
			System.out.println("File not found.");
			System.exit(1);
		}
		
		Class testClass;
		TestThread tThread;
		
		int totalPoints=0;
		int totalPossiblePoints=0;
		try {
			//Reader in the file with the test classnames in it
			String inString=reader.readLine();
			while (inString!=null) {
				if (inString.equals("")) continue;
				System.out.println();
				StringTokenizer tokenizer=new StringTokenizer(inString);
				String className=tokenizer.nextToken();
				int possiblePoints=10;
				int timeout=5;
				try {
					possiblePoints=Integer.parseInt(tokenizer.nextToken());
					timeout=Integer.parseInt(tokenizer.nextToken());
				}
				//Just use the previously set default values if these fail
				catch (Exception e) {
				}
				totalPossiblePoints+=possiblePoints;
				try {
					//Load the classname specified in the file
					testClass=Class.forName(className);
					System.out.println("***Loading test class : "+testClass.getName());
					System.out.println("Possible points   : "+possiblePoints);
					System.out.println("Timeout (in secs) : "+timeout);
					//And create a new instance of it
					tThread=(TestThread)testClass.newInstance();
					tThread.printDescription();
					System.out.println("Trying to execute...");
					//Start the test
					tThread.start();
					try {
						int count=0;
						//Wait for it to finish or timeout seconds, whichever is first
						while ((!tThread.isDone()) && (count<timeout)) {
							Thread.sleep(1000);
							count++;
							System.out.println(count+" seconds elapsed");
						}
					}
					catch (InterruptedException e) {
					}
					//Check if the thread actually finished
					if (tThread.isDone()) {
						//Check if the thread threw an exception
						if (tThread.hadException()) {
							Exception tThreadException=tThread.getException();
							System.out.println("**Exception thrown during execution");
							System.out.println("Exception   : "+tThreadException);
						}
						else {
							//If all went well, add the number of points to the
							//point total
							System.out.println("Test terminated.");
						}
					}
					//If the thread never finished, probably an infinite loop
					else {
						System.out.println("**Test didn't terminate within specified timeout.");
						System.out.println("Probably an inifinite loop or inefficient implementation.");
						System.out.println("Killing thread...");
						tThread.interrupt();
					}
					int points=tThread.getPoints();
					System.out.println("**Points: "+points+"/"+possiblePoints);
					totalPoints+=points;
				}
				catch (ClassCastException e) {
					System.out.println("**Class "+className+" not of type TestThread!");
					System.out.println("Skipping test.");					
				}
				catch (ClassNotFoundException e) {
					System.out.println("**Class "+className+" not found!");
					System.out.println("Skipping test.");
				}
				catch (InstantiationException e) {
					System.out.println("**Could not instantiate "+className+"!");
					System.out.println("Skipping test.");
				}
				catch (IllegalAccessException e) {
					System.out.println("**Illegal access on "+className+"!");
					System.out.println("Skipping test.");
				}
				System.out.print("Press Enter to continue...");
				System.in.read();
				System.in.read();
				inString=reader.readLine();
			}
			//Display the total points
			System.out.println("*********Total points: "+totalPoints+"/"+totalPossiblePoints+"*********");
		}
		catch (IOException e) {
			System.out.println("**IOException while reading file!");
			System.out.println("Ending tests.");
		}
		System.exit(0);
	}
	
}