import java.util.*;

/**
 * An interface for a PriorityQueue (PQ).
 * A PQ extends Collection by adding methods for
 * getFirst(), removeFirst(), and comparator().
 */
interface PriorityQueue extends Collection {

	/*
	 The following methods are inherited from Collection:
	 add(Object o) 
	 boolean addAll(Collection c) 
	 void clear() 
	 boolean contains(Object o) 
	 boolean containsAll(Collection c) 
	 boolean equals(Object o) 
	 int hashCode() 
	 boolean isEmpty() 
	 Iterator iterator() 
	 boolean remove(Object o) 
	 boolean removeAll(Collection c) 
	 boolean retainAll(Collection c) 
	 int size() 
	 Object[] toArray() 
	 Object[] toArray(Object[] a) 
	 */

	/*
	 * Returns the first (lowest) object in the PQ.
	 * @return the first object
	 * @exception NoSuchElementException if the PQ is empty
	 */
	public Object getFirst ();
	
	/**
	 * Returns the first (lowest) object in the PQ and remove it.
	 * @return the first object
	 * @exception NoSuchElementException if the PQ is empty
	 */
	public Object removeFirst ();
	
	/**
	 * Returns the Comparator being used by this PQ, or null
	 * if the elements' natural order is being used.
	 * @return the Comparator being used
	 */
	public Comparator comparator ();
}


