import java.util.Iterator;

public class HeapTest5 extends TestThread {
	
	public void test() {
		HeapPQ heap=new HeapPQ();
		System.out.println("Adding elements to heap");
		for (int i=4;i>=0;i--) {
			heap.add(new Integer(i));
		}		
		
		System.out.println("Getting Iterator (multiple times) and iterating through heap");
		Iterator iter=heap.iterator();
		for (int i=0;i<10;i++) {
			iter=heap.iterator();
		}
		int i=0;
		boolean success=true;
		while (iter.hasNext() && (i<5)) {
			Integer newInt=(Integer)iter.next();
			try {
				newInt.intValue();
				i++;
			}
			catch (ClassCastException e) {
				System.out.println("Element was of wrong type!? No credit...");
				success=false;
			}
			catch (NullPointerException e) {
				System.out.println("Element was empty!? No credit...");
				success=false;
			}
		}
		if (i!=5) {
			System.out.println("Iterator iterated through wrong number of elements!");
		}
		else {
			points+=3;
			if (success) points+=2;
		}
		
		iter=heap.iterator();
		try {
			iter.remove();
			Integer newInt=(Integer)iter.next();
			if (newInt.intValue()==0) {
				points+=5;
			}
			else {
				System.out.println("Remove() function not disabled on iterator!");
			}
		}
		catch (UnsupportedOperationException e) {
			points+=5;
		}
	}
	
	public void printDescription() {
		System.out.println("Test the iterator() and returned Iterator.");
	}
}
	