import java.util.Comparator;

public class HeapTest3 extends TestThread {
	
	class BackwardsComparator implements Comparator {
		public int compare(Object obj1,Object obj2) {
			Comparable c1=(Comparable)obj1;
			Comparable c2=(Comparable)obj2;
			return -(c1.compareTo(c2));
		}
	}		
	
	public void test() {
		System.out.println("Calling HeapPQ(Comparator) constructor");
		HeapPQ heap=new HeapPQ(new BackwardsComparator());
		points+=2;
		
		System.out.println("Adding items to heap");
		for (int i=0;i<5;i++) {
			heap.add(new Integer(i));
		}
		System.out.println("Removing items from heap");
		for (int i=4;i>=0;i--) {
			Integer newInt=(Integer)heap.removeFirst();
			if (newInt.intValue()==i) {
				points++;
			}
			else {
				System.out.println("Wrong value from heap! Excepted "+i);
			}
		}
		System.out.println("Testing comparator() method");
		Comparator comp=heap.comparator();
		if (!(comp instanceof BackwardsComparator)) {
			System.out.println("Did not return proper comparator!");
		}
		else {
			points+=3;
		}
	}
	
	public void printDescription() {
		System.out.println("Tests the HeapPQ(Comparator) constructor with a backwards Comparator");
	}
}
	