import javax.swing.*;
import javax.swing.tree.*;
import java.awt.event.*;
import java.awt.*;
import java.io.*;
import java.util.*;

public class GUITest extends JFrame implements ActionListener
{
	JButton addButton;
	JTextField valueField;
	JButton removeButton;
	JTextArea status;
	JScrollPane treePane;
	JTree heapTree;
	Container content;
	Box treeBox;
	Box buttonBox;
	Box vertBox;
	
	PriorityQueue pq;
	
	public GUITest() {
		//Setup all the GUI stuff
		super("CS211 Priority Queue Test");
		addButton=new JButton("Add");
		addButton.addActionListener(this);
		
		removeButton=new JButton("Remove");
		removeButton.addActionListener(this);
		
		valueField=new JTextField("Enter a String value");
		valueField.setSize(new Dimension(100,20));
				
		heapTree=new JTree(new DefaultMutableTreeNode(""));
		heapTree.setVisibleRowCount(50);
		treePane=new JScrollPane(heapTree);
		treePane.setSize(new Dimension(450,350));

		content=getContentPane();

		vertBox=Box.createVerticalBox();
		vertBox.setSize(new Dimension(450,480));
		
		buttonBox=Box.createHorizontalBox();
		buttonBox.setSize(new Dimension(450,20));
		buttonBox.add(valueField);
		buttonBox.add(addButton);
		buttonBox.add(removeButton);
		
		treeBox=Box.createHorizontalBox();
		treeBox.setSize(new Dimension(450,460));
		treeBox.add(treePane);
		
		vertBox.add(buttonBox);
		vertBox.add(treeBox);
		
		content.add(vertBox);
		
		pq=new HeapPQ();
		
		pack();
		reshape(100,100,500,500);
		show();
	}
	
	public void actionPerformed(ActionEvent e) {
		if (e.getSource()==addButton) {
			//Add an element to the heap
			pq.add(valueField.getText());
			System.out.println("Added "+valueField.getText()+"\n");
			updateTree();
		}
		else if (e.getSource()==removeButton) {
			try {
				//Remove the first element of the heap
				Object obj=pq.removeFirst();
				System.out.println("Removed "+obj+"\n");
				updateTree();
			}
			catch (NoSuchElementException nsee) {
				System.out.println("Priority queue is empty!\n");
			}
		}
	}
	
	public void updateTree() {
		//Get all nodes in the heap
		Iterator iter=pq.iterator();
		ArrayList list=new ArrayList(pq.size());
		while (iter.hasNext()) {
			String next=iter.next().toString();
			list.add(new DefaultMutableTreeNode(next));
		}
		
		//Set up the nodes for the JTree
		//based on the structure of the heap array
		for (int i=0;i<list.size();i++) {
			DefaultMutableTreeNode node=(DefaultMutableTreeNode)list.get(i);
			int lchild=i*2+1;
			int rchild=i*2+2;
			if (lchild<list.size()) {
				node.add((DefaultMutableTreeNode)list.get(lchild));
			}
			if (rchild<list.size()) {
				node.add((DefaultMutableTreeNode)list.get(rchild));
			}
		}
		
		//Do all the GUI stuff
		if (list.size()>0) {
			heapTree=new JTree((DefaultMutableTreeNode)list.get(0));
		}
		else {
			heapTree=new JTree(new DefaultMutableTreeNode(""));
		}
		heapTree.setVisibleRowCount(50);
		for(int x=0; x<heapTree.getRowCount(); x++)
		    heapTree.expandRow(x);
		treePane=new JScrollPane(heapTree);
		treePane.setSize(new Dimension(450,350));
			
		//Ugly Swing stuff to get the window to repaint
		content=getContentPane();
		content.removeAll();
		content.invalidate();
		content.repaint();

		vertBox=Box.createVerticalBox();
		vertBox.setSize(new Dimension(450,480));
		
		buttonBox=Box.createHorizontalBox();
		buttonBox.setSize(new Dimension(450,20));
		buttonBox.add(valueField);
		buttonBox.add(addButton);
		buttonBox.add(removeButton);
		
		treeBox=Box.createHorizontalBox();
		treeBox.setSize(new Dimension(450,460));
		treeBox.add(treePane);
		
		vertBox.add(buttonBox);
		vertBox.add(treeBox);
		
		content.add(vertBox);
		setContentPane(content);
		reshape(100,100,500,500);
	}
	
	public static void main(String[] args) {
		System.out.println("Hit Ctrl-Break to exit...");
		new GUITest();
	}
	
}
