import java.io.*;
import java.awt.*;
import java.util.*;

public class WordCounter extends Frame
{
	public static void main(String[] args) throws IOException
	{
		WordCounter wc = new WordCounter();

		// Open a dialog box
		FileDialog fd = new FileDialog(wc, "Open a text file");
		fd.setVisible(true);
		
		// Get the name of the selected file and open it.
		String dirName = fd.getDirectory();
		String fileName = fd.getFile();
		File textFile = new File(dirName, fileName);

		// Your code should be here.

		String line;           // each line read from textFile
		StringTokenizer st;    // string tokenizer for each line
		String token;          // each token in a line from string tokenizer
		int numWords = 0;      // number of all words with duplicacy

		/* Create a FileReader from textFile, and wrap it by buffered reader.
		   BufferedReader is not required, but buffered input/output is more efficient
		   in practice. See description of Class BufferedReader in Java API documentation. */
		
		BufferedReader in = new BufferedReader(new FileReader(textFile));

		/* Create an empty set of words. HashSet contains no duplicate elements.
           So its size should be the total number of distinct words.	*/
		
		HashSet wordSet = new HashSet();
		
		// Read each line from textFile until reaching end of file.
		while ((line = in.readLine()) != null) {
			// Create a string tokenizer for the line.
			st = new StringTokenizer(line, ",. \t\n");
			// Read each token(i.e. word), add it into the set, and increment count.
			while (st.hasMoreTokens()) {
				token = st.nextToken();
				// Add the word converted to lower case so that only one of
				// duplicate words will be stored ignoring case.
				wordSet.add(token.toLowerCase());
				numWords++;
			}
		}
		in.close();
		
		// Print out the number of all words and the number of all distinct words
		System.out.println(numWords + " " + wordSet.size());

		System.exit(0);
	}
}
