=public class BinarySearchTree
{
	/**
	 * A single node of a BST.
	 * You shouldn't change this class.
	 */
	static class Node {
        String data; 
        Node lchild;
        Node rchild;

        Node (String data) {
            this.data = data;
            lchild = null;
            rchild = null;
        }
    }

    private Node root;		// Root node for the BST

	/**
	 * Create an empty BST.
	 */
    BinarySearchTree ()
	{
		root = null;
	}

	/**
	 * Add a new data item to a BST.
	 * Each data item can only appear once in the tree.  If an
	 * attempt is made to enter a data item that already appears
	 * then nothing should happen.
	 * @param data the item to place in the BST
	 */
	public void add (String data)
	{
		// Your code should be here

		// if the tree is empty, make a singleton tree
		if (root == null) {
			root = new Node(data);
			return;
		}
		
		// Iterative algorithm to add a new node.
		// (This can be done in recursive way as well)

		Node t = root;

		/* Traverse down the tree from the root to add a node.
		- If the tree already contains data, the loop terminates by
		  finding that node. The tree is not modified at all.
		- If data does not appear in the tree, either of two if() conditions
		  is met eventually and the new node is placed where it should be.
		  At the beginning of next iteration, t.data == data is met
		  since t is the added node. The loop terminates.
		*/
		while (!data.equals(t.data))
			if (data.compareTo(t.data) < 0) {
				if (t.lchild == null) t.lchild = new Node(data);
				t = t.lchild;
			}
			else {
				if (t.rchild == null) t.rchild = new Node(data);
				t = t.rchild;
			}
	}
	
	/**
	 * Return a String that represents this BST.
	 * The string is a "sideways" version of the tree.  The root
	 * is to the left and the left- and right-subtrees are down
	 * and up (respectively) from the root.
	 * @return a String representation of the BST
	 */
    public String toString ()
	{
		// Your code should be here
		
		// Use a helper function toStringWithLevel() to get the result.
		return toStringWithLevel(root, 0);
	}
	/**
	 * Return a string that represents the tree rooted at Node t,
	 * provided that t is at level k. The string to be returned is:
	 * (string from right subtree) + (t.data) + (string from left subtree).
	 * The current level k should be passed while recursion
	 * in order to have proper number of blanks before each node.
	 * @return a string representation of a subtree rooted at t.
	 * @param t root of the subtree whose string representation will be returned.
	 * @param k level of t. Level of the root is considered 0.
	 */
	private static String toStringWithLevel(Node t, int k)
	{
		String s;

		// Return empty string for empty tree (base case of recursion)
		if (t == null) return "";
		
		// Get the result from right subtree, with level increased by 1
		s = toStringWithLevel(t.rchild, k + 1);
		// Add to s the line for Node t, which is (4*k) blanks followed by t.data
		for (int i = 0; i < 4 * k; i++) s += " ";
		s += t.data + "\n";
		// add to s the result from left subtree, with level increased by 1
		s += toStringWithLevel(t.lchild, k + 1);
		return s;
	}
}
