
import java.util.NoSuchElementException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;

/**
 * Does parsing of simple expressions.
 * This version has only a main program; you have to provide the rest.
 */
class Parser {

 	/* 
 	 * You will need to create fields and methods here.  The fields
 	 * are used to maintain the current state of the parser.  Useful
 	 * fields might include the current expression being parsed, the
 	 * ExpressionTokenizer, and the current values of x and y.
 	 * You need to create a constructor, and methods for
 	 * expression, term, and factor.  You may find it useful to create
 	 * additional methods and fields.
 	 */

	String expression;	// holds the original expression String
	ExpressionTokenizer tokenizer;
	double x;
	double y;
 	
	/**
	 * Constructor.
	 */
	public Parser( String exp ) {
		expression = exp;
	}

	/**
	 * Evaluate the original String expression in x and y
	 */
	public double evaluate( double x, double y ) {
		this.x = x;
		this.y = y;
		tokenizer = new ExpressionTokenizer( expression );
		tokenizer.debug = false;

		double result = evalExpression();
		String token = tokenizer.nextToken();
		if( token.equals("end-of-line") )
			return result;
		else
			throw new IllegalArgumentException( "Extra characters on line." );
	}

	/**
	 * Evaluate a tokenized expression
	 */
	public double evalExpression() {
		double result = evalTerm();
		String token = tokenizer.nextToken();
		while( token.equals("+") || token.equals("-") ) {
			if( token.equals("+") )	result += evalTerm();
			else					result -= evalTerm();
			token = tokenizer.nextToken();
		}
		tokenizer.pushBack();
		return result;
	}

	/**
	 * Evaluate a term
	 */
	public double evalTerm() {
		double result = evalFactor();
		String token = tokenizer.nextToken();
		while( token.equals("*") || token.equals("/") ) {
			if( token.equals("*") )	result *= evalFactor();
			else					result /= evalFactor();
			token = tokenizer.nextToken();
		}
		tokenizer.pushBack();
		return result;
	}

	/**
	 * Evaluate a factor
	 */
	public double evalFactor() {
		double result;
		double arg1, arg2;
		String token = tokenizer.nextToken().toLowerCase();
		if( token.equals("end-of-line") )
			throw new IllegalArgumentException( "Missing characters." );

		char c = token.charAt(0);
		if( '0'<=c && c<='9' || c=='.' )	// constant
			try {
				result = Double.parseDouble( token );
			} catch( NumberFormatException e ) {
				throw new IllegalArgumentException( "Badly formed number: " + token );
			}
		else if( token.equals("x") )
			result = x;
		else if( token.equals("y") )
			result = y;
		else if( token.equals("(") ) {
			result = evalExpression();
			if( ! tokenizer.nextToken().equals(")") )
				throw new IllegalArgumentException( "Missing )" );
		}
		else if( token.equals("sin") || token.equals("cos") ) {
			if( ! tokenizer.nextToken().equals("(") )
				throw new IllegalArgumentException( "Missing (" );
			arg1 = evalExpression();
			if( ! tokenizer.nextToken().equals(")") )
				throw new IllegalArgumentException( "Missing )" );
			result = token.equals("sin") ? Math.sin(arg1) : Math.cos(arg1);
		}
		else if( token.equals("max") || token.equals("min") ) {
			if( ! tokenizer.nextToken().equals("(") )
				throw new IllegalArgumentException( "Missing (" );
			arg1 = evalExpression();
			if( ! tokenizer.nextToken().equals(",") )
				throw new IllegalArgumentException( "Missing ," );
			arg2 = evalExpression();
			if( ! tokenizer.nextToken().equals(")") )
				throw new IllegalArgumentException( "Missing )" );
			result = token.equals("max") ?
				Math.max( arg1, arg2 ) : Math.min( arg1, arg2 );
		}
		else
			throw new IllegalArgumentException( "Bad token: " + token );
		return result;
	}
 

 	 /**
	  * Main program reads expressions, one per line, and evaluates
	  * them.  Takes a single command-line arg specifying the
	  * size of the matrix on which the expression is evaluated.
	  */
	 public static void main (String[] arg) {
	 	int size = 1;			// Size of the output matrix
	 	String expression;		// Input expression
	 	Parser parser;			// The parser/evaluator

	 	// Look for a command line argument

	 	if (arg.length != 1) {
	 		System.out.println("Need a command line argument.");
	 		System.out.println("In CodeWarrior, select 'Java Application Settings...' in the Edit menu.");
	 		System.out.println("Place your argument in the 'Parameters' box.");
	 		throw new IllegalArgumentException();
	 		}

	 	// Determine the size of the output matrix
	 	try {
	 		size = Integer.parseInt(arg[0]);
	 		}
	 	catch (NumberFormatException e) {
	 		System.out.println("Bad number on command line.");
	 		throw new IllegalArgumentException();
	 		}

	 	// Prepare the standard input for reading lines
	 	BufferedReader in = 
			new BufferedReader(new InputStreamReader(System.in));

		// Read expressions, one per line, until an empty line is read
		while (true) {
			try {
				System.out.print("Input: ");
				expression = in.readLine();
				if (expression.equals("")) break;
System.out.println( expression );
				parser = new Parser(expression);

				// Print the output in matrix form
				for (int j = 0; j < size; j++) {
					for (int i = 0; i < size; i++) {
						System.out.print(parser.evaluate(i,j) + " ");
						}
					System.out.println();
					}
					System.out.println();
				}

			// This exception occurs if you read past end-of-line
			catch (NoSuchElementException e) {
				System.out.println("Read past end-of-file\n");
				}

			// This exception occurs when a failed attempt is made to
			// convert a String into a Double using Double.valueOf()
			catch (NumberFormatException e) {
				System.out.println("Badly formed number\n");
				}

			// This exception should occur if something goes wrong
			// while parsing; the message should be helpful.
			catch (IllegalArgumentException e) {
				System.out.println(e.getMessage() + '\n');
				}

			// This shouldn't occur, but is required when reading
			// from a file.
			catch (IOException e) {
				System.out.println("Unknown IO problem.\n");
				}
			}
		}
	}

						





