/**
 * General-purpose assertion method(s).
 */

class SanityCheck {
  /**
   * Throws an exception if <code>sanityCondition</code> is <code>false</code>.
   * <p>
   * Typically, this method is used to double-check that various
   * "should always be true" conditions are being honored.  For example,
   * <pre>
   *   // height should always be positive
   *   SanityCheck.assert(height > 0, "non-positive height");
   * </pre>
   * Can be very useful when developing new code, since it can detect problems
   * early, before they metastasize to other sections of program.
   *
   * @param  message  the explanatory message to be included in the exception
   * @throws SanityCheckFailedException  the condition turned out to be false
   */
  final public static void assert(boolean sanityCondition, String message) {
    if (sanityCondition)  return;

    throw new SanityCheckFailedException(message);
  }

  // SanityCheck is entirely static, so we should "hide" its constructor...
  private SanityCheck()  { }
}
