/**
 * Encapsulates a mutable <code>int</code>.   A <code>MyInteger</code>
 * object stores a single integer value, and that integer value may
 * change during the lifetime of the object.
 * <p>
 * [<code>MyInteger</code> is compatible only with itself.]
 */

class MyInteger implements MyIntegralNumber {
  /**
   * The stored integer value.
   */
  private int value;

  /**
   * Constructs a new <code>MyInteger</code> object that initially stores
   * the integer value <code>i</code>.
   *
   * @param  i  the integer value to initially store in the new object
   */
  public MyInteger(int i)  { value = i; }

  /**
   * Constructs a new <code>MyInteger</code> object that initially stores
   * the integer value <code>0</code>.
   */
  public MyInteger()  { value = 0; }

  /**
   * Constructs a new <code>MyInteger</code> object that initially stores
   * the integer value whose decimal representation is <code>decimal</code>.
   */
  public MyInteger(String decimal)
    { value = Integer.parseInt(decimal); }

  public Object clone()
    { return new MyInteger(value); }

  public MyNumber createCompatible(int i)
    { return new MyInteger(i); }

  public boolean lessThan(MyNumber n)
    { return (value <  ((MyInteger) n).value); }

  public boolean equals(Object o)
    { return (o instanceof MyInteger) && value == ((MyInteger) o).value; }

  public void minus()
    { value = -value; }

  public void  plus(MyNumber n)
    { value += ((MyInteger) n).value; }

  public void times(MyNumber n)
    { value *= ((MyInteger) n).value; }

  public MyNumber squareOf()
    { return new MyInteger(value * value); }

  public boolean divides(MyIntegralNumber n)
    { return (0 == ((MyInteger) n).value % value); }

  public String toString()  { return String.valueOf(value); }

  // ...we'll ignore hashCode, for now...
}
