/**
 * Factorization of <code>MyIntegralNumber</code>s.
 */

class Factorize {
  /**
   * Prints "Prime" on the terminal if <code>ival</code> is prime; otherwise,
   * prints a non-trivial factor of <code>ival</code>.
   * <p>
   * [<code>ival</code> is assumed to be odd and greater than 100.]
   *
   * @param  ival  the integer to be factored
   */
  public static void getFactor(MyIntegralNumber ival) {
    MyIntegralNumber  two    = (MyIntegralNumber) ival.createCompatible(2);
    MyIntegralNumber  factor = (MyIntegralNumber) ival.createCompatible(3);

    while (true) {
      if (factor.divides(ival))
        { System.out.println(factor);   return; }

      if (! factor.squareOf().lessThan(ival))
        { System.out.println("Prime");  return; }

      factor.plus(two);
    }
  }

  // Factorize is entirely static, so we should "hide" its constructor...
  private Factorize()  { }
}
