/**
 * A mutable, arbitrary-precision integer.  An arithmetic operation on a
 * <code>MyBigInteger</code> never results in overflow or "wrap
 * around"---instead, the sequence of digits expands as necessary to
 * accomodate any increase in the stored value's magnitude.  For example,
 *
 * <pre>   MyBigInteger i = new MyBigInteger(65536);
 *
 *   System.out.println(i);  // 65536
 *   i = i.squareOf();
 *   System.out.println(i);  // 4294967296
 *   i = i.squareOf();
 *   System.out.println(i);  // 18446744073709551616
 *   i = i.squareOf();
 *   System.out.println(i);  // 340282366920938463463374607431768211456
 *   i = i.squareOf();
 *   System.out.println(i);  // 115792089237316195423570985008687907853
 *                           //  269984665640564039457584007913129639936
 * 
 *   MyBigInteger j = new MyBigInteger(1);
 *   j.plus(i);
 *   System.out.println(j);  // 115792089237316195423570985008687907853
 *                           //  269984665640564039457584007913129639937</pre>
 *
 * [When they're printed via <code>System.out.println</code>,
 * <code>MyBigInteger</code>s are displayed in decimal, as implied
 * by the specification of <code>toString</code> in <code>MyNumber</code>.]
 * <p>
 * [In its internal storage, a <code>MyBigInteger</code> is free to use any radix
 * that is convenient.]
 */

class MyBigInteger implements MyIntegralNumber {
  /**
   * Constructs a new <code>MyBigInteger</code> object that initially stores
   * the integer value <code>i</code>.
   *
   * @param  i  the integer value to initially store in the new object
   */
  public MyBigInteger(int i)
    { /* ... */ }

  public Object clone()
    { return null;  /* ... */ }

  public MyNumber createCompatible(int i)
    { return null;  /* ... */ }

  public boolean lessThan(MyNumber n)
    { return false;  /* ... */ }

  public boolean equals(Object o)
    { return false;  /* ... */ }

  public void minus()
    { /* ... */ }

  public void plus(MyNumber n)
    { /* ... */ }

  public MyNumber squareOf()
    { return null;  /* ... */ }

  public void times(MyNumber n)
    { /* ... */ }

  public boolean divides(MyIntegralNumber n)
    { return false;  /* ... */ }

  public String toString()
    { return null;  /* ... */ }

  // ...we'll ignore hashCode, for now...
}
