public class SaMmy implements SaM, Runnable {

    //********data declarations**************************** 
    protected int maxProgram = 300; //max of 300 instructions
    protected int maxStack = 10000; //allocate 10000 locations for stack

    protected int PC;               //Program Counter
    protected I_Instruction[] Program = new I_Instruction[maxProgram]; 
    protected int FBR;
    protected int SP, HP;
    protected int[] Stack  = new int[maxStack];
    protected int HALT;
    private IDisplay Screen = null;

    public Thread runner;           //thread for running programs

    //********end of data declarations****************************

    public void setPC(int v)     { PC = v; }

    public int getPC()           { return PC; }

    public void setFBR(int v)    { FBR = v; }

    public int getFBR()          { return FBR; }

    public int getSP()           { return SP; }

    public void setSP(int v)     { SP = v;}

    public int getHP()           { return HP; }

    public void setHP(int v)     { HP = v;}

    public void incPC()          { PC++; }

    public int getMaxStack()     { return maxStack; }

    public int getStack(int i)   { return Stack[i]; }

    public int getStackElement(int a)                 { return Stack[a]; }
     
    public void setStackElement(int a, int v)         { Stack[a] = v; }

    public I_Instruction getInstruction(int i) { return Program[i]; }

    public boolean setInstruction(int a, I_Instruction ins) {
        if (a >= maxProgram) {
	        println("setInstruction for address " + a + 
                    "failed: program array has size " + maxProgram);
	        return false;
        } else {
	        Program[a] = ins;
	        return true;
        }
    }

    public void halt()            { HALT = 1; }

    public void setGUI(IDisplay b) { Screen = b; }

    public void push(int v) {
        Stack[SP] = v;
        SP++;
    }

    public int pop() {
        SP--;
        return Stack[SP];
    }

    //**************************************************************************
    //Convenient getter methods 

    public void dumpState() {
		println("****Printing SaM state****");
		println("SP: " + SP);
		println("PC: " + PC);
		println("FBR: " + FBR);
		println("HALT: " + HALT);
		
		//print out all values on stack from 0 to SP-1
		println("Values on Stack, starting at address 0");
		for (int i = 0; i < SP; i++) {
			print (" " + Stack[i]);
			if (i>0 && 0==i%9) println("");
		}
		println("");

		//print values on heap 
		println("Values in Heap, starting at address " + (maxStack - 1) );
		for (int i = maxStack - 1; i > HP; i--) {
			print (" " + Stack[i]);
			if (i>0 && 0==i%9) println("");
		}
		println("");
		
		println("****End of SaM state****");
    }

    public void dumpProgram(int PSize) {
		println("Dumping program");
		for (int i = 0; i < PSize; i++)
			println(Program[i].toString());
    }

    //**************************************************************************
    //SaMmy's print method
    public void println(String s) {
		if (Screen == null) System.out.println(s);
		else Screen.println(s);
    }  
  
    public void print(String s) {
		if (Screen == null) System.out.print(s);
		else Screen.print(s);
    }

    public void update() {
		if (Screen != null) Screen.update();
    }

    //call back for GUI
    public void runDone() {
		if (Screen == null) {
			 System.out.println("Execution terminated normally");
			 dumpState();
		} else
             Screen.runDone();
    }

    //**************************************************************************
    public void reboot() {
		SP = 0;
		HP = maxStack - 1;
		FBR = 0;
		PC = 0;
		HALT = 0;
		println("I am SaM.");
    }

    public void powerOff() {
		println("I'll be back.");
    }

    // two pass loader: first pass reads in instructions into Program array
    // but does not translate symbolic operands. second pass performs translation
    // returns number of instructions read in
    public int load(String ProgramFile) {
        CS211InInterface inf = new CS211In(ProgramFile);//create input manager
        return load(inf);
    }

    public int load(CS211InInterface inf) {
		SymbolTable ST = new SymbolTable();
		int LC = 0;// LC is where next instruction should be put 
		
		// First Pass
		LC = 0;
		FirstLoop:
		while (inf.peekAtKind() != inf.EOF) { 
			String s = inf.getWord();
			//eat up labels
			while (s.endsWith(":")) {
				String tmpstr = s.substring(0,s.length()-1);  
				boolean success = ST.insert(tmpstr,LC);
				if (! success) println("Multiply defined label " + tmpstr );
				//check for dangling label at end of file
				if (inf.peekAtKind() == inf.EOF) break FirstLoop;
				else s = inf.getWord();
			}
			
			//at this point, s should contain the opcode
			I_Instruction i;
			try  { 
			    i = (I_Instruction)(Class.forName(s + "Inst")).newInstance();
			} catch (Exception e) {
			    println("Funny opcode " + s);
			    return -1;
			}
			i.readOperand(inf);
			Program[LC] = i;
			LC++;
		}
		inf.close();
		
		// Second Pass
		for (int i = 0; i < LC; i++) {
		    if (Program[i] == null) println("Null instruction at location " + i);
		    else Program[i].translate(ST, this);
		}
		return LC;
    }

    public void start () {
		if (runner == null) {
			runner = new Thread(this,"Runner");
			runner.start(); //call start method of thread
		}
    }
    
    public void stop() {
        runner = null;
    }
    
    public void step() {
        Program[PC].execute(this);
    }  
    
    public void run( ) {
		String s;
		while (runner != null) { //if not aborted
			I_Instruction inst = Program[PC];
			inst.execute(this);
			update();
			if (HALT == 1)
			    break;
			else 
			    try {runner.sleep((long)50);} 
			    catch (InterruptedException e) {
                    // println("Interrupted while sleeping");
                }
		}
		
		if (HALT != 1) { //program was aborted
		    println("Program Aborted");
		    reboot();
		} else { //return value at bottom of stack
		     if (SP == 1) println("Answer is " + getStackElement(0));
		     else println("Program terminated normally"); //but SP is not equal to 1 ???");
        }

		runner = null;      
		runDone(); //call back for updating display
    }        
}


//*************************************************************************************