//***********Interface for Stack Machine *************************************
interface SaM {

	//getter and setter methods
	void setFBR(int v);
	int  getFBR();
	void setPC(int v);
	int  getPC(); 
	void setSP(int v);
	int  getSP(); 
	void setHP(int v);
	int  getHP();
	void setStackElement(int a, int v); //Stack[a] = v;
	int  getStackElement(int a);        //return Stack[a]
	I_Instruction getInstruction(int a);             // instruction at Program[i]
	boolean setInstruction(int a, I_Instruction ins);// set instruction at Program[i]
	
	//convenient setter and getter methods
	void push(int v);
	int  pop();
	void incPC();
	void dumpProgram(int PSize);   //PSize is number of instructions in program
	void dumpState();
	
	//work-horses
	void setGUI(IDisplay d);
	void reboot();
	void start();                  //begin execution
	int load(String s);            //file name
	int load(CS211InInterface inf);//takes an input manager as input
	                               //returns number of instructions read
	void run();                    //used by Runnable interface
	void step();                   //execute one instruction
	void stop();                   //terminate execution
	void halt();
	void powerOff();
	void println(String s);        //for reporting errors to SaM
	void print(String s);
}
