//sorting routines for sorting in increasing order

import java.util.*;
import java.io.*;

class SortComparableArray {

  //************Selection Sort***************************************************
  public static void selectionSort(Comparable[] a) {
    for (int i = 0; i < a.length; i++) {
      //find minimum position
      int MinPos = i;
      for (int j = i+1; j < a.length; j++) {
	if (a[j].compareTo(a[MinPos]) < 0) 
	  MinPos = j;
      }          
      //swap
      Comparable temp = a[i];
      a[i] = a[MinPos];
      a[MinPos] = temp;}
  }

  //************Merge Sort***************************************************
  public static Comparable[] mergeSort(Comparable[] A, int low, int high) {
    if (low < high - 1) //at least three elements
      {int mid = (low + high)/2;
       Comparable[] A1 = mergeSort(A, low, mid);
       Comparable[] A2 = mergeSort(A, mid +1, high);
       return merge(A1,A2);}
    else //0,1,or 2 elements
      {int length = high - low +1;
       Comparable[] r = new Comparable[length];
       if (length == 1) r[0] = A[low];
       if (length == 2)
             if(A[low].compareTo(A[high]) < 0)
                {r[0] = A[low];
                 r[1] = A[high];}
             else 
                {r[0] = A[high];
                 r[1] = A[low];
                }
      return r;
      }
  }

  public static Comparable[] merge(Comparable[] a1, Comparable[] a2) {
     Comparable[] m = new Comparable[a1.length + a2.length];
     int p1 = 0;
     int p2 = 0;
     int pm = 0;
     while ((p1 < a1.length) && (p2 < a2.length))
         if (a1[p1].compareTo(a2[p2]) <= 0) m[pm++] = a1[p1++];
         else m[pm++] = a2[p2++];
     //either a1 or a2 will empty at this point
     for(; p1 < a1.length; p1++) //merge any leftovers from a1
         m[pm++] = a1[p1];
     for(; p2 < a2.length; p2++) //merge any leftovers from a2
         m[pm++] = a2[p2];
     return m;
  }

  //*************Quick Sort**************************************************

  public static int partition(Comparable[] A, int low, int high, Comparable pivot) {
     int i = low;
     int j = high;
     while (true) {
       while ((i < A.length) && (A[i].compareTo(pivot) < 0)) i++;//advance left index
       while ((j >= 0) && (pivot.compareTo(A[j]) < 0)) j--;//advance right index
       if (i < j) //swap
         {Comparable temp = A[i];
	  A[i] = A[j];
	  A[j] = temp;
	  i++;
	  j--;
          }
       else break;
      }
    return i;
  }

  public static void quickSort(Comparable[] A, int l, int h) {
    if (l < h) 
        {int p = partition(A,l+1,h,A[l]);
             //move pivot into its final resting place
             //swap A[p-1] and A[l]
             Comparable temp = A[p-1];
	     A[p-1] = A[l];
	     A[l] = temp;
	       quickSort(A,l,p-1);
               quickSort(A,p,h);
        }
  }
}

class testSort{

  public static void main(String[] args) {

   Comparable[] ar = new Comparable[20];
   for (int i = 0; i < ar.length; i++)
     ar[i] = i + "boo";

   printArray(ar);
   printArray(SortComparableArray.mergeSort(ar,0,ar.length -1));

  }



  public static void printArray(Comparable[] ar) {

   for (int i = 0; i < ar.length; i++)
     System.out.print(ar[i] + " ");
   System.out.println(" ");
  }
}
