//Illustrates linear and binary search of a sorted array of ints

import java.util.*;
import java.io.*;

class SearchIntArray {


  //linear search on possibly unsorted array
 public static boolean linearSearch(int[] a, int v) {
   int i = 0;
   while (i < a.length)
     if (a[i] == v) return true;
     else i++;
   return false;
 }

  //binary search on sorted array
  //left and right are the two end points of interval
  public static boolean binarySearch(int[] a, int v) {
    int left = 0;
    int right = a.length - 1;
    int middle = 0;

    while (left <= right){
        middle = (left + right)/2;
	int test = a[middle] - v;
	if (test < 0) left = middle+1;
	else 
	  if (test == 0) {
	    return true;
	  }
	  else right = middle-1;
    }
    //if we reach here, we didn't find the object
    return false;
  }
}


class testSearchIntArray {

  public static void main(String[] args) {

   int[] ar = new int[100];
   for (int i = 0; i < ar.length; i++)
     ar[i] = i*i;

   System.out.println("Linear search " + SearchIntArray.linearSearch(ar,1));
   System.out.println("Binary search " + SearchIntArray.binarySearch(ar,1));

   System.out.println("Linear search " + SearchIntArray.linearSearch(ar,10000));
   System.out.println("Binary search " + SearchIntArray.binarySearch(ar,10000));

  }
}
