//Illustrates linear and binary search of a sorted array
//of Comparable

import java.util.*;
import java.io.*;

class SearchComparableArray {


  //linear search on possibly unsorted array
 public static boolean linearSearch(Comparable[] a, Object v) {
   int i = 0;
   while (i < a.length)
     if (a[i].compareTo(v) == 0) return true;
     else i++;
   return false;
 }

  //binary search on sorted array
  //left and right are the two end points of interval
  public static boolean binarySearch(Comparable[] a, Object v) {
    int left = 0;
    int right = a.length - 1;
    int middle = 0;

    while (left <= right){
        middle = (left + right)/2;
	int test = a[middle].compareTo(v); //int test = a[middle] - v;
	if (test < 0) left = middle+1;
	else 
	  if (test == 0) {
	    return true;
	  }
	  else right = middle-1;
    }
    //if we reach here, we didn't find the object
    return false;
  }
}


class testSearchComparableArray {

  public static void main(String[] args) {

   Comparable[] ar = new Comparable[100];
   for (int i = 0; i < ar.length; i++)
     ar[i] = "boo" + (200 +i);

   System.out.println("Linear search " + SearchComparableArray.linearSearch(ar,"boo201"));
   System.out.println("Binary search " + SearchComparableArray.binarySearch(ar,"boo201"));

   System.out.println("Linear search " + SearchComparableArray.linearSearch(ar,"boo299"));
   System.out.println("Binary search " + SearchComparableArray.binarySearch(ar,"boo299"));

  }
}
