//demonstrates the use of inner classes to implement Iterator interface

import java.util.*;
import java.io.*;

class manyBoosIter {
  protected Comparable[] ar;

  public manyBoosIter(int n) {
    ar = new Comparable[n];
    for (int i = 0; i < n; i++)
      ar[i] = i + "boo";
  }

 public Iterator iterator() {
   return new booIterator();
 }
 
//*******Iterator implemented using an inner class******
 protected class booIterator implements Iterator {
   int cursor;

   public booIterator() {
     cursor = 0;
   }
   public boolean hasNext() {
     return (cursor < ar.length);
   }
   public Object next() {
     return ar[cursor++];
   }   
   public void remove() {
     //unimplemented method
   }
 }
//*******end of Iterator inner class********************
}

//*******************************************************************
class Search {

  //linear search on 
  public static boolean linearSearch(Iterator a, Object v) {
    while (a.hasNext())
      if (((Comparable)a.next()).compareTo(v) == 0) return true;
    return false;
  }
}

//*******************************************************************
class testCursorIterator{

  public static void main(String[] args) {

   manyBoosIter b = new manyBoosIter(20);

   //we can use the iterator to print the array
   Iterator i = b.iterator();
   while(i.hasNext()) 
     System.out.print(i.next() + " ");
   System.out.println();
  
   //do a linear search 
   System.out.println("Found 9boo? " + Search.linearSearch(b.iterator(), "9boo"));
   System.out.println("Found 99boo? " + Search.linearSearch(b.iterator(), "99boo"));
  }
}

