//search structure implemented as unsorted list
//sorting is pointless because you cannot do binary search anyway
class SSAsList implements SearchStructure{
  protected ListCell data;
  int size;
  //two cursors for list walking
  ListCell current;
  ListCell previous;

  public SSAsList() {
  }

  public void insert(Object o) {
                                
    //if o is not already in list
    if (! search(o)) {
      //stick into head of list 
      data = new ListCell(o, data);
      size = size + 1;
    }
  }

  public void delete(Object o){ //remove objects equal to o 
     boolean found = search(o);
     if (! found) return;
     //need to delete from search structure
     //use the two cursors current and previous
     //we know that current is non-null
     //previous will be null if element to be deleted is first in list
     if (previous == null) {
       //need to remove first element of list
       data = data.getNext();
     }
     else //splice out current element of list
       previous.setNext(current.getNext());

     size = size - 1;
     return;
  }

  //linear search
  public boolean search(Object o){
     //walk down the list
     current = data;
     previous = null;
     while (current != null) {
       Comparable d = (Comparable)(current.getDatum());
       if (d.compareTo(o) == 0) return true;
       else {
	 previous = current;
	 current = current.getNext();
       }
     }
     return false;
  }


  public int size() {
    return this.size;
  }

  public String toString() {
    return "Search Structure has " + size + " elements:" + data.toString();
  }
}


class testSSAsList {
 public static void main(String[] args) {
 SSAsList ss = new SSAsList();
 System.out.println(ss.search(new Integer(5)));
 ss.insert(new Integer(5));
 ss.insert(new Integer(89));
 ss.insert(new Integer(5));
 System.out.println(ss.size()); //should be 2 not 3
 System.out.println(ss);
 System.out.println(ss.search(new Integer(5))); //true
 System.out.println(ss.search(new Integer(89))); //true
 ss.delete(new Integer(89));
 System.out.println(ss);
 System.out.println(ss.search(new Integer(5))); //false
 System.out.println(ss.search(new Integer(89))); //true

 }
}
