//stack implemented using lists

class StackAsList implements SeqStructure{
 
  protected ListCell data;

  public StackAsList() {
  }

  public void put(Object o) {//prepend o to list l
    data = new ListCell(o,data);
  }

  //define the usual stack synonym for put
  public void push(Object o) {
    put(o);
  }

  public Object get() {//remove and return first element of list l
    if (! isEmpty()){
      Object v = data.getDatum();
      data = data.getNext();
      return v;}
    else 
      {System.out.println(
			  "Malfunction: attempt to Get from empty SeqStructure");
      return null;
      }
  }

  //define the usual stack synonym for get
  public Object pop() {
    return get();
  }

  public boolean isEmpty() {//any elements in data??
    return (data == null);
  }

  public int size() {
    int v = 0;
    ListCell finger = data;
    //this is called "walking down the list"
    while (finger != null) {
      v = v + 1;
      finger = finger.getNext();}
    return v;
  }


  public String toString() {
    if (isEmpty()) return "Empty Stack";
    return "Stack elements from top to bottom:" + data;
  }
}

class testStackAsList{
  public static void main(String[] args) {
    StackAsList s = new StackAsList();
    s.push("Billy");
    s.push("Silly");
    System.out.println(s);
    System.out.println(s.pop());
    System.out.println(s.pop());
  }
}
