//a LIFO sequence structure using arrays

//data collection class. 
//For now, we will exploit the fact that protected variables
//are visible to all classes in same package
//There's nothing particularly sorted about this array
//when it is used to implement stacks.
class SortedArray{

  protected Object[] ar;
  protected int size;
  protected int MAXSIZE;

  public SortedArray(int n) {
    ar = new Object[n];
    MAXSIZE = n;
    size = 0;
  }
}

class StackAsArray implements SeqStructure {

  protected SortedArray s;
  protected int SP; //points to first empty cell

  public StackAsArray(int size) {
   s = new SortedArray(size);
  }

  public Object get() {
   if (SP == 0) {
        System.out.println("Attempt to pop empty stack");
        return null;}
   SP = SP -1;
   Object temp = s.ar[SP];
   s.ar[SP] = null;
   return temp;
 }
 
  public void put(Object o) {
   if (SP == s.MAXSIZE) {
        System.out.println("Stack overflow");
        return; }
   s.ar[SP] = o;
   SP = SP + 1; 
  }

  public int size() {
   return SP; 
  }
 
  public boolean isEmpty() {
   return (SP == 0); 
  }

 public String toString() {
   if (SP == 0) return "Empty stack";
   String rString = "Stack elements from bottom to top: ";
   for (int i = 0; i < SP; i++) 
     rString = rString + " " + s.ar[i];
   return rString;
 }
}


class testStack {

  public static void main(String[] args) {

   StackAsArray s = new StackAsArray(10);
   System.out.println(s);
   s.put(new Integer(10));
   System.out.println(s);
   s.put(new Integer(20));
   System.out.println(s);
   s.put(new Integer(30));
   System.out.println(s.get());
   s.put(new Integer(20));
   System.out.println(s.get());
   System.out.println(s.get());
   System.out.println(s.get());
   System.out.println(s.get());

  }
}
