/*
  SortedArray maintains a multiset as a sorted array.
  This class is not used anymore.
  It has linear and binary search methods for searching the filled
  portion of the array.
  It does not have any routines for inserting or deleting elements
  from the array - these are provided by subclassing this array.
*/

import java.util.*;
import java.io.*;

class SortedArray {

 protected Comparable[] ar;
 protected int size;
 protected int MAXSIZE;
 protected int cursor;
 
  public SortedArrayCursor(int n) {
   ar = new Comparable[n];
   MAXSIZE = n;
   size = 0;
  }

  public int size() {
   return size;
  }

  public boolean isEmpty() {
    return (size == 0);
  }

  //linear search takes O(n) time on array of size n
 public boolean dumbSearch(Object o) {
   for (int i = 0; i < size; i++)
     if (ar[i].compareTo(o) == 0) 
       {System.out.println("Linear search made " + (i+1) + " comparisons");
        cursor = i;
        return true;
       }
   return false;
 }

  //binary search on array sorted in increasing order
  //it takes O(log(n)) time for an array of size n
  public boolean search(Object o) {
    //left and right are the two end points of interval
    int left = 0;
    int right = size - 1;
    int middle = 0;//initialization needed for empty array case
    int count = 0;//keep track of comparisons

    while (left <= right){
        middle = (left + right)/2;
      int test = ar[middle].compareTo(o);
          count++;
      if (test < 0) left = middle+1;
      else 
	if (test == 0) {
	  System.out.println("Binary search made " + count + " comparisons");
          cursor = middle;
	  return true;
	}
	else right = middle-1;
    }
    //if we reach here, we didn't find the object
    System.out.println("Binary search made " + count + " comparisons");
    cursor = right + 1;
    return false;
  }

 public String toString() {
   if (size == 0) return "Empty Array.";
   String rString = "Array elements: ";
   for (int i = 0; i < size; i++) 
     rString = rString + " " + ar[i];
   return rString;
 }
}


