//Search Structure implemented using sorted arrays
//Only Comparable objects can be put in data structure.
//search method is binary search: O(log(n))
//insertion and deletion take O(n) time

import java.util.*;
import java.io.*;


//data collection class
//For now, we will exploit the fact that protected variables
//are visible to all classes in same package
class SortedArray{

  protected Object[] ar;
  protected int size;
  protected int MAXSIZE;

  public SortedArray(int n) {
    ar = new Comparable[n];
    MAXSIZE = n;
    size = 0;
  }
}


class SSAsSortedArray implements SearchStructure{

  protected SortedArray s;
  protected int cursor;

  public SSAsSortedArray(int n) {
    s = new SortedArray(n);
  }

  public int size() {
   return s.size;
  }

  public boolean isEmpty() {
    return (s.size == 0);
  }

  //binary search on array sorted in increasing order
  //it takes O(log(n)) time for an array of size n
  public boolean search(Object o) {
    //left and right are the two end points of interval
    int left = 0;
    int right = s.size - 1;
    int middle = 0;//initialization needed for empty array case
    int count = 0;//keep track of comparisons

    while (left <= right){
        middle = (left + right)/2;
      int test = ((Comparable)(s.ar[middle])).compareTo(o);
          count++;
      if (test < 0) left = middle+1;
      else
        if (test == 0) {
          System.out.println("Binary search made " + count + " comparisons");
          cursor = middle;
          return true;
        }
        else right = middle-1;
    }
    //if we reach here, we didn't find the object
    System.out.println("Binary search made " + count + " comparisons");
    cursor = right + 1;
    return false;
  }


  //insert with no duplicates
  public void insert(Object o) {
    //set cursor using search
    boolean found = search(o);
    if (found) return;

    //we did not find it
    if (s.size == s.MAXSIZE) {
      System.out.println("Error: Search Structure overflow");
      return;}
    //shift right all items to right of insertion index
    for (int j = s.size-1; j >= cursor; j--)
      s.ar[j+1] = s.ar[j];
    //insert item
    s.ar[cursor] = (Comparable)o;
    s.size = s.size +1;
    System.out.println("Inserted " + o + " at index " + cursor);
  }

 //uses search to locate the object; then deletes it
 public void delete(Object o) {
   //set the cursor using search
   boolean found = search(o);
   //remove element by shifting left all items to right of object in array
   if (found) {
     for (int j = cursor+1; j < s.size; j++)
       s.ar[j-1] = s.ar[j];
     s.size = s.size -1;
     System.out.println("Deleted " + o);
   }
   else System.out.println("Delete did not find " + o);
 }

  //printing the search structure
  public String toString() {
    if (s.size == 0) return "Empty Search Structure.";
    String rString = "Search Structure Elements: ";
    for (int i = 0; i < s.size; i++)
      rString = rString + " " + s.ar[i];
    return rString;
  }
}


class testSSAsSortedArray {

  public static void main(String[] args) {

   SSAsSortedArray ss = new SSAsSortedArray(10);
   System.out.println(ss); //should print empty
   ss.insert("Hillary");
   System.out.println(ss);
   ss.insert("Monica");
   System.out.println(ss); 
   ss.delete("Hillary");
   System.out.println(ss); 
   ss.delete("Gennifer");
   System.out.println(ss); 
   ss.insert("Linda");
   System.out.println(ss); 
   ss.insert("Bill");
   System.out.println(ss); 
   ss.insert("Kathleen");
   System.out.println(ss); 
   ss.insert("Sally");
   System.out.println(ss); 
   ss.delete("Kathleen");
   System.out.println(ss); 
   System.out.println("SS size is " + ss.size());
  }
}
