//Queue implemented using an array as a ring buffer

//data collection class
//For now, we will exploit the fact that protected variables
//are visible to all classes in same package
class SortedArray{

  protected Object[] ar;
  protected int size;
  protected int MAXSIZE;

  public SortedArray(int n) {
    ar = new Comparable[n];
    MAXSIZE = n;
    size = 0;
  }
}

class QAsArray implements SeqStructure {
 protected SortedArray s;
 protected int head = 0; //points to element for dequeue
 protected int tail = 0; //points to empty slot for enqueue

 public QAsArray(int n) {
   s = new SortedArray(n); 
 }

 public Object get() {
   if (s.size == 0) {
	System.out.println("Cannot get from empty queue");
        return null;}
   //since s.size is not 0, we know head must point to a valid item
   Object temp = s.ar[head];
   s.ar[head] = null;
   head = head + 1;
   if (head == s.MAXSIZE) //wrap-around
     head = 0;
   s.size = s.size - 1;
   System.out.println("Dequeued " + temp);
   return temp;
 }

 public void put(Object o) {
   if (s.size == s.MAXSIZE) {
	System.out.println("Queue overflow");
        return;}
   //we have not filled queue, so tail must point to an empty slot
   s.ar[tail] = o;
   tail = tail + 1;
   if (tail == s.MAXSIZE) tail = 0;
   s.size = s.size + 1;
   System.out.println("Enqueued " + o);
 }

 public int size() {
   return s.size; 
 }

 public boolean isEmpty() {
   return (s.size == 0); 
 }

 public String toString() {
   if (s.size == 0) return "Empty queue";
   String rString = "Queue items in first-in order:\n";
   //there is at least one item in queue
   int indx = head;

   do {
     rString = rString + " " + s.ar[indx];
     indx++;     
     //check for wrap-around
     if (indx == s.MAXSIZE) indx = 0;
   } while (indx != tail);

   return rString;
 }
}

class testQAsArray {

  public static void main(String[] args) {
    QAsArray q = new QAsArray(4);
    for (int i = 0; i < 5; i++) 
      q.put("S" + i);
    System.out.println(q);
    System.out.println(q.get()); //should print "S0"    
    System.out.println(q);
    System.out.println(q.get()); //should print "S1"
    System.out.println(q);

    q.put("S5");
    System.out.println(q);
    q.put("S6");
    System.out.println(q);
    System.out.println(q.get()); //should print "S2"    
    System.out.println(q);    
  }
}
