import java.util.*;
import java.io.*;

//a priority queue using sorted arrays
//items higher priority are later in array
//items with same priority are in increasing order of tenure
//get: O(1)
//put: O(n)


//data collection class
//For now, we will exploit the fact that protected variables
//are visible to all classes in same package
class SortedArray{

  protected Object[] ar;
  protected int size;
  protected int MAXSIZE;

  public SortedArray(int n) {
    ar = new Object[n];
    MAXSIZE = n;
    size = 0;
  }
}

class PQAsSortedArray implements SeqStructure {

 protected SortedArray s;
 protected int cursor;

 public PQAsSortedArray(int n) { 
   s = new SortedArray(n);
 }

  public boolean isEmpty() {
   return (s.size == 0);
  }

  public int size() {
    return s.size;
  }

  //binary search on array sorted in increasing order
  //it takes O(log(n)) time for an array of size n
  public boolean search(Object o) {
    //left and right are the two end points of interval
    int left = 0;
    int right = s.size - 1;
    int middle = 0;//initialization needed for empty array case
    int count = 0;//keep track of comparisons

    while (left <= right){
        middle = (left + right)/2;
      int test = ((Comparable)(s.ar[middle])).compareTo(o);
          count++;
      if (test < 0) left = middle+1;
      else
        if (test == 0) {
          System.out.println("Binary search made " + count + " comparisons");
          cursor = middle;
          return true;
        }
        else right = middle-1;
    }
    //if we reach here, we didn't find the object
    System.out.println("Binary search made " + count + " comparisons");
    cursor = right + 1;
    return false;
  }



 public Object get() {
   //check for empty PQ
   if (s.size == 0) {
	System.out.println("Error: Attempt to get from empty PQ");
        return null;}
   //get the rightmost item
   System.out.println("Removed " + s.ar[s.size -1]);
   s.size = s.size - 1;
   return s.ar[s.size];
 }  

  //insert into right place in sorted array
 public void put(Object o) {
   if (s.size == s.MAXSIZE) {
	System.out.println("Error: Priority Queue overflow");
        return;}
   //set the cursor to point to where insertion should take place
   boolean found = search(o);  
   
   //find leftmost object equal to o
   while (cursor > 0 && ((PQElement)(s.ar[cursor - 1])).compareTo(o) == 0)
     cursor--;

   //make room for new element by shifting elements to left of cursor
   for (int i = s.size -1; i >= cursor;i--)
     s.ar[i+1] = s.ar[i];

   s.ar[cursor] = (PQElement)o;//throw exception if o is not PQElement
   s.size = s.size + 1;
   System.out.println("Inserted " + o + " at " + cursor);
 }

  //printing the search structure
  public String toString() {
    if (s.size == 0) return "Empty Search Structure.";
    String rString = "Search Structure Elements:\n";
    for (int i = 0; i < s.size; i++)
      rString = rString + " " + s.ar[i];
    return rString;
  }



}
   


class testPQ {

  public static void main(String[] args) {

   PQAsSortedArray pq = new PQAsSortedArray(10);
   System.out.println(pq); //should print empty
   pq.put(new PQElement("Bill",3));
   System.out.println(pq); //should print ((Bill,3))
   pq.put(new PQElement("Monica",1));
   System.out.println(pq); //should print ((Bill,3),(Monica,1))
   pq.put(new PQElement("Hillary",4));
   System.out.println(pq); //should print ((Bill,3),(Monica,1),(Hillary,4))
   System.out.println(pq.get()); //(Hillary,4)
   System.out.println(pq); //((Bill,3),(Monica,1))
   pq.put(new PQElement("Gennifer",3)); 
   System.out.println(pq);//((Bill,3),(Monica,1),(Gennifer,3))
   System.out.println(pq.get());// (Bill,3)
   System.out.println(pq); //((Monica,1),(Gennifer,3))
   System.out.println(pq.get());//(Gennifer,3)
   System.out.println(pq);//((Monica,1))
   System.out.println(pq.get());//(Monica,1)
   System.out.println(pq);//empty
   System.out.println(pq.get());//error
   System.out.println(pq);//empty 

  }



}
