//interface for puzzles
//by convention, classes implementing this interface 
//will override the equals and clone methods from Object
interface IPuzzle {
    int rows(); //number of rows in puzzle
    int cols(); //number of columns in puzzle
    boolean isSorted();//returns true if puzzle is in sorted state
    void scramble(); //put puzzle into some mixed-up configuration
    boolean isEmpty(int i,int j);//is row i, column j empty?
    int tile(int i, int j); //what is tile in row i and col j?
    boolean move(char ch); //move a tile N,S,E, or W
    IPuzzle duplicate(); //clone the puzzle
}


