//an implementation of the IPuzzle interface
//it uses arrays to represent the configuration of tiles

import java.io.*;
import java.util.*;

class ArrayPuzzle implements IPuzzle, Comparable{

 protected static final int rows = 3;
 protected static final int cols = 3;
  //empty position will have the following number in it
 protected static final int emptyNumber = rows*cols;; 

 protected int[][] state = new int[rows][cols];
  //keep track of where the empty position is
 protected int emptyRow = -1;
 protected int emptyCol = -1;

  //constructor for puzzle: creates puzzle in sorted state
 public ArrayPuzzle() {
   for (int i = 0; i < rows; i++)
     for (int j = 0; j < cols; j++)
        state[i][j] = i*cols + j + 1;
   emptyRow = rows -1;
   emptyCol = cols -1;
 }

  //return number of rows 
 public int rows() {
  return rows;
 }

  //return number of columns
 public int cols() {
  return cols;
 }

  //The equals method overrides the method in Object.
  //It returns false even if the parameter is an object
  //of another class that implements the IPuzzle interface.
  //This can be fixed by using more advanced reflection, but we will not
  //do this yet.
 public boolean equals(Object o) {
   if (! (o instanceof ArrayPuzzle)) 
     return false;
   ArrayPuzzle p = (ArrayPuzzle)o;
   for (int i = 0; i < rows; i++)
     for (int j = 0; j < cols; j++) 
       if (p.state[i][j] != state[i][j])
	 return false;
   return true;
 }

  //to compare two configurations, write down the tiles in the configurations
  //top to bottom and left to right order using 9 for empty space,
  //and treat as an integer to be compared.
  public int compareTo(Object o) {
   if (!(o instanceof ArrayPuzzle)) 
     return +1; //cannot really compare them, so arbitrary

   IPuzzle p = (IPuzzle)o;
   for (int i = 0; i < rows; i++)
     for (int j = 0; j < cols; j++) 
       if (p.isEmpty(i,j))
	 if (this.isEmpty(i,j))
	   continue;
         else return -1;
       else 
         if (this.isEmpty(i,j))
           return +1;
         else {
	   int myTile  = tile(i,j);
           int herTile = p.tile(i,j);
           if (myTile < herTile)
	     return -1;
           else 
	     if (myTile == herTile)
                continue;
             else return +1;
	 }
   //if we reach here, all tiles were identical
   return 0;
  }

  //for printing puzzle
 public String toString(){
  String rString  = "Puzzle Configuration:\n";
  for (int i = 0; i < rows(); i++) {
     for (int j = 0; j < cols(); j++) {
       if (isEmpty(i,j))
	 rString += "  ";
       else 
	 rString += tile(i,j) + " ";
     }
     rString += "\n";
  }
  return rString;
 }

  //duplicates this object. 
 public ArrayPuzzle duplicate() {
   //Create a new puzzle
   ArrayPuzzle np = new ArrayPuzzle();
   //Put it into the same state as this object.
   for (int i = 0; i < rows; i++)
     for (int j = 0; j < cols; j++) 
       np.state[i][j] = state[i][j];
   np.emptyRow = emptyRow;
   np.emptyCol = emptyCol;
   return np;
 }

  //is puzzle in sorted state?
  public boolean isSorted() {
   for (int i = 0; i < rows; i++)
     for (int j = 0; j < cols; j++)
        if (state[i][j] != i*cols + j + 1) return false;
   return true;
 }

  //scramble works by making a sequence of moves
  //starting from the sorted position
 public void scramble() {
   for (int i = 0; i < rows; i++)
     for (int j = 0; j < cols; j++)
        state[i][j] = i*rows + j + 1;
   state[rows-1][cols-1] = emptyNumber;
   emptyRow = rows -1;
   emptyCol = cols -1;
   String M =  "SESENNWSESSENNW";
   for (int i = 0; i < M.length(); i++)
       move(M.charAt(i));
 }

  //is row i, column j empty? 
 public boolean isEmpty(int i, int j) {
 return (i == emptyRow) && (j == emptyCol); 
 }


  //return tile in a particular position
 public int tile(int i, int j) {
   return state[i][j];
 }

  //perform move in N,S,E,W direction
 public boolean move(char ch) {
   int r = emptyRow;
   int c = emptyCol;

   switch (ch) {
    case 'N': r = emptyRow + 1; break;
    case 'S': r = emptyRow - 1; break;
    case 'E': c = emptyCol - 1; break;
    case 'W': c = emptyCol + 1; break;
   }
   //check legality

   if ((r < 0 ) || (r > rows -1) || (c < 0) || (c > cols -1))
      return false;
   
   state[emptyRow][emptyCol] = state[r][c];
   state[r][c] = 0;
   emptyRow = r;
   emptyCol = c;
   return true;
	}      
}
