//
//  AppDelegate.swift
//  Goats2
//
//  Created by Daniel Hauagge on 2/29/16.
//  Copyright © 2016 Daniel Hauagge. All rights reserved.
//

import UIKit
import RealmSwift
import SwiftyJSON
import Alamofire

@UIApplicationMain
class AppDelegate: UIResponder, UIApplicationDelegate {
    
    var window: UIWindow?
    
    
    func application(application: UIApplication, didFinishLaunchingWithOptions launchOptions: [NSObject: AnyObject]?) -> Bool {
        // Override point for customization after application launch.
        return true
    }
    
    func applicationWillResignActive(application: UIApplication) {
        // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
        // Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
    }
    
    func applicationDidEnterBackground(application: UIApplication) {
        // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
        // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
    }
    
    func applicationWillEnterForeground(application: UIApplication) {
        // Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
    }
    
    func applicationDidBecomeActive(application: UIApplication) {
        // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
        
        dispatch_async(dispatch_queue_create("background", nil)) {
            while(true) {
                //print("background process")
                
                let realm = try! Realm()
                realm.refresh()
                
                var goatNames = [String]()
                for goat in realm.objects(Goat) {
                    goatNames.append(goat.name)
                }
                print(goatNames)
                Alamofire.request(.GET, "http://169.54.42.86:9000/position", parameters:["goats": goatNames])
                    .validate().responseJSON { response in
                        
                        switch response.result {
                        case .Success:
                            if let value = response.result.value {
                                let json = JSON(value)
                                
                                    let realm = try! Realm()
                                    try! realm.write({ 
                                        for goat in realm.objects(Goat) {
                                            
                                            let lat = json[goat.name]["latitude"].doubleValue
                                            let lon = json[goat.name]["longitude"].doubleValue
                                            
                                            goat.latitude = lat
                                            goat.longitude = lon
                                        }
                                    })
                            }
                            
                        case .Failure(let error):
                            print(error)
                        }
                        
                }
                
                NSThread.sleepForTimeInterval(1)
            }
        }
    }
    
    func applicationWillTerminate(application: UIApplication) {
        // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
    }
    
    
}

