//
//  ViewController.swift
//  Goats2
//
//  Created by Daniel Hauagge on 2/29/16.
//  Copyright © 2016 Daniel Hauagge. All rights reserved.
//

import UIKit
import RealmSwift

class ViewController: UIViewController, UITextFieldDelegate {
    @IBOutlet weak var nameTextField: UITextField!
    @IBOutlet weak var doneButton: UIButton!
    @IBOutlet weak var ageTextField: UITextField!

    var goat = Goat()

    override func viewDidLoad() {
        super.viewDidLoad()
        
        nameTextField.delegate = self
        ageTextField.delegate = self
        
        nameTextField.text = goat.name
        ageTextField.text = "\(goat.age)"
        
        doneButton.enabled = false
        
        validateValues()
    }

    func validateValues() {
        let name = nameTextField.text!
        let age = Int(ageTextField.text!)
        
        if (!name.isEmpty) && (age != nil) {
            doneButton.enabled = true
        }
        
    }

    func exitView() {
        let isInNavigationControllerStack = presentingViewController is UINavigationController
        
        if isInNavigationControllerStack {
            dismissViewControllerAnimated(true, completion: nil)
        } else {
            // navigationController!.popViewControllerAnimated(true)
            print("\(navigationController!.viewControllers.count)")
//            navigationController!.popToRootViewControllerAnimated(true)
            navigationController!.popViewControllerAnimated(true)
            print("\(navigationController!)")
            navigationController!.popViewControllerAnimated(true)
        }
    }
    
    // MARK: - Actions
    @IBAction func doneButtonClicked(sender: AnyObject) {
        let realm = try! Realm()
        
        try! realm.write {
            goat.name = nameTextField.text!
            goat.age = Int(ageTextField.text!)!
            realm.add(goat, update: true)
        }
        print("\(realm.objects(Goat).count) goats in DB")
        
        exitView()
    }

    @IBAction func cancelButtonClicked(sender: UIBarButtonItem) {
        exitView()
    }
    
    // MARK: - Dismissing the keyboard
    func textFieldShouldReturn(textField: UITextField) -> Bool {
        textField.resignFirstResponder()
        return false
    }
    
    override func touchesBegan(touches: Set<UITouch>, withEvent event: UIEvent?) {
        nameTextField.resignFirstResponder()
        ageTextField.resignFirstResponder()
    }
    
    func textFieldDidEndEditing(textField: UITextField) {
        validateValues()
    }
}

