//
//  TableViewController.swift
//  Goats2
//
//  Created by Daniel Hauagge on 2/29/16.
//  Copyright © 2016 Daniel Hauagge. All rights reserved.
//

import UIKit
import RealmSwift

class TableViewController: UITableViewController {
    
    var realmToken : NotificationToken!
    
    override func awakeFromNib() {
        let realm = try! Realm()
        
        realmToken = realm.addNotificationBlock { (notification, realm) -> Void in
            self.tableView.reloadData()
        }
        
        // to disable the token
        // realmToken.stop()
    }
    
    override func numberOfSectionsInTableView(tableView: UITableView) -> Int {
        return 1
    }
    
    override func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        let realm = try! Realm()
        return realm.objects(Goat).count
    }
    
    override func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        let cellIdentifier = "GoatCellView"
        let cell = tableView.dequeueReusableCellWithIdentifier(cellIdentifier, forIndexPath: indexPath) as! GoatCellView
        
        let realm = try! Realm()
        
        let goat = realm.objects(Goat)[indexPath.row]
        
        cell.nameLabel.text = goat.name
        cell.ageLabel.text = "\(goat.age)"
        
        return cell
    }
    
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {

        if segue.identifier == "showDetail" {
            let goatDetailView = segue.destinationViewController as! ViewController

            if let goatCell = sender as? GoatCellView {
                let idx = tableView.indexPathForCell(goatCell)!.row
                
                let realm = try! Realm()
                
                let goat = realm.objects(Goat)[idx]
                
                goatDetailView.goat = goat
            }
        } else if segue.identifier == "AddGoat" {
            //goatDetailView.goat = Goat()
            if let nav = segue.destinationViewController as? UINavigationController {
                if let goatDetailView = nav.viewControllers[0] as? ViewController {
                    goatDetailView.goat = Goat()
                }
            }
            
        }
    }
}
