import  java.io.*;
import  java.util.*;
import  javax.swing.*;

// The translator of a small program. All the fields and methods are static.
public class Translator {
    private static BufferedReader br; // Reader attached to the file chosen by the user
    
    // word + line is the part of the current line that's not yet processed
    // word has no whitespace
    // If word and line are not empty, line begins with whitespace
    private static String line="";    
    private static String word=""; 
    
    private static Labels labels; // The labels of the program being translated 
    private static Vector program;   // The program to be created  
    
    // Obtain a file name from the user and translate the 
    // small program in that file into lab (the labels) and
    // prog (the program)
    // return "no errors were detected"
    public static boolean readAndTranslate(Labels lab, Vector prog) {
        try {
            getReader();
        } catch(IOException ioE) {
            System.out.println("Sai: IO error to start " );
            return false;
        }
        labels= lab;
        labels.reset();
        program= prog;
        program.removeAllElements();
        
        try { line = br.readLine();
        }
        catch (IOException ioE) {
            return false;
        }
	
        // Each iteration processes line and reads the next line into line
        while (line != null) {
            // Store the label in label
	    String label= scan(); 
            
            if (label.length() > 0) {
		
                Instruction ins= getInstruction(label);
                if ( ins != null ) {
                    labels.addLabel(label); 
                    program.addElement(ins);  
                }
            }
            
            try { line = br.readLine();
            }
            catch (IOException ioE) {
                return false;
            }
	    
        }
        return true;
    }
    
    // line should consist of an MML instruction, with its label already
    // removed. Translate line into an instruction with label label
    // and return the instruction
    public static Instruction getInstruction(String label) {
        int s1;   // Possible operands of the instruction
        int s2;
        int r;
        int x;
        String L2;
        
        String ins= scan();
        if (line.equals("")) return null;
        
        if (ins.equals("add")) {
            r= scanInt();
            s1= scanInt();
            s2= scanInt();
            return new AddInstruction(label, r, s1, s2);
        }
        
        // You will have to write code here for the other instructions.
  
        return null;
     }
     
    
     // Display a JFileChooser and set br to a reader for the file chosen
     private static void getReader() throws IOException {
       JFileChooser chooser = new JFileChooser("C:\\Windows\\Desktop\\compiler\\test0.txt");
       chooser.setDialogTitle("Choose the File that contains the MML program to be executed");
       chooser.showOpenDialog(null);
       br =  new BufferedReader(new FileReader(chooser.getSelectedFile()));
     }
    
    // Return the first word of line and remove it from line.
    // If there is no word, return ""
    public static String scan() {
        line= line.trim();
        if (line.length() == 0) 
            {   return "";   }
        int i= 0;
        while (i < line.length() &&
               line.charAt(i) != ' ' &&
               line.charAt(i) != '\t') {
            i= i+1;
        }
        word= line.substring(0,i);
        line= line.substring(i);
        return word;
    }
    
    // Return the first word of line as an integer. If there is
    // any error, return the maximum int
    public static int scanInt() {
        String word= scan();
        if (word.length() == 0)
            { return Integer.MAX_VALUE; }
            
        try {
            return Integer.parseInt(word);
        } catch (NumberFormatException e) {
            return Integer.MAX_VALUE;
        }
    }
}
