// An instance contains 31 registers and methods to access
// and change them
public class Registers {
    private int registers[]= new int[31];
    
    // Constructor: an instance whose registers are set to 0
    public Registers() {
        for (int i= 0; i != registers.length; i++) {
            registers[i]= 0;
        }
    }
    
    // = the value in register i.
    // Precondition: 0 <= i < 32
    public int getRegister(int i) {
        return registers[i];
    }
    
    // Set register i to v.
    // Precondition: 0 <= i < 32
    public void setRegister(int i, int v) {
        registers[i]= v;
    }
    
    // =  a representation of the registers,
    //    "(reg 0, reg 1, ..., reg 31)"
    public String toString() {
        String r= "(" + registers[0];
        // invariant: r contains the representation for registers[0..i-1]
        // (with the opening "(" but no closing ")")
        for (int i= 1; i != registers.length; i++) {
            r= r + ", " + registers[i];
        }
        r= r + ")";
        return r;
    }
}
