import java.util.*;

// The machine language interpreter
public class Machine {
    // The labels in the MML program, in the order in which
    // they appear (are defined) in the program
    private Labels labels= new Labels(); 
    
    // The MML program, consisting of prog.size() instructions, each
    // of class Instruction (or one of its subclasses)
    private Vector prog= new Vector();   
    
    // The registers of the MML machine
    private Registers registers;
    
    // The program counter; it contains the index (in prog) of
    // the next instruction to be executed.
    private int PC= 0;

    public static void main (String[] pars) {
        
        Machine m= new Machine();
        Translator.readAndTranslate(m.labels, m.prog);

        System.out.println("Here is the program; it has " +
			   m.prog.size() + " instructions.");
        m.print();
        System.out.println();
        
        System.out.println("Beginning program execution.");
        m.execute();
	System.out.println("Ending program execution.");
 		   
        System.out.println("Values of registers at program termination:");
        System.out.println(m.registers + ".");
	System.exit(0);
    }
    
    // Print the program
    public void print() {
        for (int i= 0; i != prog.size(); i++) {
            System.out.println((Instruction) prog.elementAt(i));
        }
    }

    // Execute the program in prog, beginning at instruction 0.
    // Precondition: the program and its labels have been store properly.
    public void execute() {
	PC= 0;
	registers= new Registers();
	while (PC < prog.size()) {
	    Instruction ins= (Instruction)prog.elementAt(PC);
	    PC= PC+1;
	    ins.execute(this);
	}
    }
    
    // = the registers of this machine
    public Registers getRegisters() {
	return registers;
    }
    
    // = the labels of this machine
    public Labels getLabels() {
	return labels;
    }
    
    // Set the program counter to pc
    public void setPC(int pc) {
	PC= pc;
    }
}
