import java.util.*;

// An instance contains a list of Strings, called "labels",
// in the order in which they were added to the list. 
public class Labels {
    private Vector labels= new Vector();

    // Constructor: an empty list of labels
    public Labels() {
    }
    
    // Add label lab to this list and return its number in the list
    // (the first one added is number 0)
    // Precondition: the list has at most 49 entries
    public int addLabel(String lab) {
        labels.addElement(lab);
        return labels.size()-1;
    }
    
    // = the number of label lab in the list
    //   (= -1 if lab is not in the list)
    public int indexOf(String lab) {
    
        // invariant: lab is not in labels[0..i-1]
        for (int i= 0; i != labels.size(); i++) {
            if (lab.equals((String)(labels.elementAt(i)))) {
                return i;
            }
        }   
        return -1;
    }
    
    // representation of this instance, "(label 0, label 1, ..., label (n-1))"
    public String toString() {
        String r= "(";
        // invariant: r contains the representation for labels[0..i-1]
        // (with the opening "(" but no closing ")")
        for (int i= 0; i != labels.size(); i++) {
            if (i == 0) {
                r= r + (String)(labels.elementAt(i));
            } else {
                r= r + ", " + (String)(labels.elementAt(i));
            }
        }
        r= r + ")";
        return r;
    }
    
    // Set the number of elements in the list to 0
    public void reset() {
        labels.removeAllElements();
    }
}
