/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FixedHeightLayoutCache
extends AbstractLayoutCache {
    private FHTreeStateNode root;
    private int rowCount;
    private Rectangle boundsBuffer;
    private Hashtable treePathMapping;
    private SearchInfo info;
    private Stack tempStacks = new Stack();

    public FixedHeightLayoutCache() {
        this.boundsBuffer = new Rectangle();
        this.treePathMapping = new Hashtable();
        this.info = new SearchInfo();
    }

    static /* synthetic */ int access$4(FixedHeightLayoutCache fixedHeightLayoutCache) {
        return fixedHeightLayoutCache.rowCount;
    }

    static /* synthetic */ FHTreeStateNode access$6(FixedHeightLayoutCache fixedHeightLayoutCache) {
        return fixedHeightLayoutCache.root;
    }

    private void addMapping(FHTreeStateNode fHTreeStateNode) {
        this.treePathMapping.put(fHTreeStateNode.getTreePath(), fHTreeStateNode);
    }

    private void adjustRowCountBy(int n) {
        this.rowCount += n;
    }

    private FHTreeStateNode createNodeForValue(Object object, int n) {
        return new FHTreeStateNode(object, n, -1);
    }

    private boolean ensurePathIsExpanded(TreePath treePath, boolean bl) {
        if (treePath != null) {
            FHTreeStateNode fHTreeStateNode;
            if (this.treeModel.isLeaf(treePath.getLastPathComponent())) {
                treePath = treePath.getParentPath();
                bl = true;
            }
            if (treePath != null && (fHTreeStateNode = this.getNodeForPath(treePath, false, true)) != null) {
                fHTreeStateNode.makeVisible();
                if (bl) {
                    fHTreeStateNode.expand();
                }
                return true;
            }
        }
        return false;
    }

    private Rectangle getBounds(FHTreeStateNode fHTreeStateNode, int n, Rectangle rectangle) {
        int n2;
        boolean bl;
        Object object;
        int n3;
        if (n == -1) {
            n3 = fHTreeStateNode.getRow();
            object = fHTreeStateNode.getUserObject();
            bl = fHTreeStateNode.isExpanded();
            n2 = fHTreeStateNode.getLevel();
        } else {
            n3 = fHTreeStateNode.getRowToModelIndex(n);
            object = this.treeModel.getChild(fHTreeStateNode.getUserObject(), n);
            bl = false;
            n2 = fHTreeStateNode.getLevel() + 1;
        }
        Rectangle rectangle2 = this.getNodeDimensions(object, n3, n2, bl, this.boundsBuffer);
        if (rectangle2 == null) {
            return null;
        }
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        rectangle.x = rectangle2.x;
        rectangle.height = this.getRowHeight();
        rectangle.y = n3 * rectangle.height;
        rectangle.width = this.boundsBuffer.width;
        return rectangle;
    }

    public Rectangle getBounds(TreePath treePath, Rectangle rectangle) {
        int n;
        if (treePath == null) {
            return null;
        }
        FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
        if (fHTreeStateNode != null) {
            return this.getBounds(fHTreeStateNode, -1, rectangle);
        }
        TreePath treePath2 = treePath.getParentPath();
        fHTreeStateNode = this.getNodeForPath(treePath2, true, false);
        if (fHTreeStateNode != null && (n = this.treeModel.getIndexOfChild(treePath2.getLastPathComponent(), treePath.getLastPathComponent())) != -1) {
            return this.getBounds(fHTreeStateNode, n, rectangle);
        }
        return null;
    }

    public boolean getExpandedState(TreePath treePath) {
        FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
        return fHTreeStateNode != null ? fHTreeStateNode.isVisible() && fHTreeStateNode.isExpanded() : false;
    }

    private FHTreeStateNode getMapping(TreePath treePath) {
        return (FHTreeStateNode)this.treePathMapping.get(treePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FHTreeStateNode getNodeForPath(TreePath treePath, boolean bl, boolean bl2) {
        if (treePath == null) return null;
        FHTreeStateNode fHTreeStateNode = this.getMapping(treePath);
        if (fHTreeStateNode != null) {
            if (!bl) return fHTreeStateNode;
            if (fHTreeStateNode.isVisible()) return fHTreeStateNode;
            return null;
        }
        if (bl) {
            return null;
        }
        Stack stack = this.tempStacks.size() == 0 ? new Stack() : (Stack)this.tempStacks.pop();
        try {
            stack.push(treePath);
            treePath = treePath.getParentPath();
            fHTreeStateNode = null;
            while (treePath != null) {
                fHTreeStateNode = this.getMapping(treePath);
                if (fHTreeStateNode != null) {
                    while (true) {
                        if (fHTreeStateNode == null || stack.size() <= 0) break;
                        treePath = (TreePath)stack.pop();
                        fHTreeStateNode = fHTreeStateNode.createChildFor(treePath.getLastPathComponent());
                    }
                    FHTreeStateNode fHTreeStateNode2 = fHTreeStateNode;
                    Object var8_7 = null;
                    stack.removeAllElements();
                    this.tempStacks.push(stack);
                    return fHTreeStateNode2;
                }
                stack.push(treePath);
                treePath = treePath.getParentPath();
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            stack.removeAllElements();
            this.tempStacks.push(stack);
            throw throwable;
        }
        Object var8_8 = null;
        stack.removeAllElements();
        this.tempStacks.push(stack);
        return null;
    }

    public TreePath getPathClosestTo(int n, int n2) {
        if (this.getRowCount() == 0) {
            return null;
        }
        int n3 = this.getRowContainingYLocation(n2);
        return this.getPathForRow(n3);
    }

    public TreePath getPathForRow(int n) {
        if (n >= 0 && n < this.getRowCount() && this.root.getPathForRow(n, this.getRowCount(), this.info)) {
            return this.info.getPath();
        }
        return null;
    }

    private int getRowContainingYLocation(int n) {
        if (this.getRowCount() == 0) {
            return -1;
        }
        return Math.max(0, Math.min(this.getRowCount() - 1, n / this.getRowHeight()));
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getRowForPath(TreePath treePath) {
        if (treePath == null || this.root == null) {
            return -1;
        }
        FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
        if (fHTreeStateNode != null) {
            return fHTreeStateNode.getRow();
        }
        TreePath treePath2 = treePath.getParentPath();
        fHTreeStateNode = this.getNodeForPath(treePath2, true, false);
        if (fHTreeStateNode != null) {
            return fHTreeStateNode.getRowToModelIndex(this.treeModel.getIndexOfChild(treePath2.getLastPathComponent(), treePath.getLastPathComponent()));
        }
        return -1;
    }

    public int getVisibleChildCount(TreePath treePath) {
        FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
        if (fHTreeStateNode == null) {
            return 0;
        }
        return fHTreeStateNode.getTotalChildCount();
    }

    public Enumeration getVisiblePathsFrom(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
        if (fHTreeStateNode != null) {
            return new VisibleFHTreeStateNodeEnumeration(fHTreeStateNode);
        }
        TreePath treePath2 = treePath.getParentPath();
        fHTreeStateNode = this.getNodeForPath(treePath2, true, false);
        if (fHTreeStateNode != null && fHTreeStateNode.isExpanded()) {
            return new VisibleFHTreeStateNodeEnumeration(fHTreeStateNode, this.treeModel.getIndexOfChild(treePath2.getLastPathComponent(), treePath.getLastPathComponent()));
        }
        return null;
    }

    public void invalidatePathBounds(TreePath treePath) {
    }

    public void invalidateSizes() {
        this.visibleNodesChanged();
    }

    public boolean isExpanded(TreePath treePath) {
        if (treePath != null) {
            FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
            return fHTreeStateNode != null && fHTreeStateNode.isExpanded();
        }
        return false;
    }

    private void rebuild() {
        this.treePathMapping.clear();
        if (this.treeModel != null) {
            Object object = this.treeModel.getRoot();
            this.root = this.createNodeForValue(object, 0);
            this.root.path = new TreePath(object);
            this.addMapping(this.root);
            if (this.isRootVisible()) {
                this.rowCount = 1;
                this.root.row = 0;
            } else {
                this.rowCount = 0;
                this.root.row = -1;
            }
            this.root.expand();
        } else {
            this.root = null;
            this.rowCount = 0;
        }
        if (this.treeSelectionModel != null) {
            this.treeSelectionModel.clearSelection();
        }
        this.visibleNodesChanged();
    }

    private void removeMapping(FHTreeStateNode fHTreeStateNode) {
        this.treePathMapping.remove(fHTreeStateNode.getTreePath());
    }

    public void setExpandedState(TreePath treePath, boolean bl) {
        if (bl) {
            this.ensurePathIsExpanded(treePath, true);
        } else if (treePath != null) {
            FHTreeStateNode fHTreeStateNode;
            TreePath treePath2 = treePath.getParentPath();
            if (treePath2 != null && (fHTreeStateNode = this.getNodeForPath(treePath2, false, true)) != null) {
                fHTreeStateNode.makeVisible();
            }
            if ((fHTreeStateNode = this.getNodeForPath(treePath, true, false)) != null) {
                fHTreeStateNode.collapse(true);
            }
        }
    }

    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
        this.rebuild();
    }

    public void setRootVisible(boolean bl) {
        if (this.isRootVisible() != bl) {
            super.setRootVisible(bl);
            if (this.root != null) {
                if (bl) {
                    ++this.rowCount;
                    this.root.adjustRowBy(1);
                } else {
                    --this.rowCount;
                    this.root.adjustRowBy(-1);
                }
                this.visibleNodesChanged();
            }
        }
    }

    public void setRowHeight(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("FixedHeightLayoutCache only supports row heights greater than 0");
        }
        if (this.getRowHeight() != n) {
            super.setRowHeight(n);
            this.visibleNodesChanged();
        }
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            int n;
            FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treeModelEvent.getTreePath(), false, false);
            int[] nArray = treeModelEvent.getChildIndices();
            if (fHTreeStateNode != null && nArray != null && (n = nArray.length) > 0) {
                Object object = fHTreeStateNode.getUserObject();
                int n2 = 0;
                while (n2 < n) {
                    FHTreeStateNode fHTreeStateNode2 = fHTreeStateNode.getChildAtModelIndex(nArray[n2]);
                    if (fHTreeStateNode2 != null) {
                        fHTreeStateNode2.setUserObject(this.treeModel.getChild(object, nArray[n2]));
                    }
                    ++n2;
                }
                if (fHTreeStateNode.isVisible() && fHTreeStateNode.isExpanded()) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            int n;
            FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treeModelEvent.getTreePath(), false, false);
            int[] nArray = treeModelEvent.getChildIndices();
            if (fHTreeStateNode != null && nArray != null && (n = nArray.length) > 0) {
                boolean bl = fHTreeStateNode.isVisible() && fHTreeStateNode.isExpanded();
                int n2 = 0;
                while (n2 < n) {
                    fHTreeStateNode.childInsertedAtModelIndex(nArray[n2], bl);
                    ++n2;
                }
                if (bl && this.treeSelectionModel != null) {
                    this.treeSelectionModel.resetRowSelection();
                }
                if (fHTreeStateNode.isVisible()) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            int n;
            TreePath treePath = treeModelEvent.getTreePath();
            FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, false, false);
            int[] nArray = treeModelEvent.getChildIndices();
            if (fHTreeStateNode != null && nArray != null && (n = nArray.length) > 0) {
                Object[] objectArray = treeModelEvent.getChildren();
                boolean bl = fHTreeStateNode.isVisible() && fHTreeStateNode.isExpanded();
                int n2 = n - 1;
                while (n2 >= 0) {
                    fHTreeStateNode.removeChildAtModelIndex(nArray[n2], bl);
                    if (this.treeSelectionModel != null && objectArray != null && objectArray[n2] != null) {
                        this.treeSelectionModel.removeSelectionPath(treePath.pathByAddingChild(objectArray[n2]));
                    }
                    --n2;
                }
                if (bl) {
                    if (this.treeSelectionModel != null) {
                        this.treeSelectionModel.resetRowSelection();
                    }
                    this.visibleNodesChanged();
                } else if (fHTreeStateNode.isVisible()) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        TreePath treePath;
        if (treeModelEvent != null && (treePath = treeModelEvent.getTreePath()) != null && treePath.getPathCount() > 0) {
            if (treePath.getPathCount() == 1) {
                this.rebuild();
            } else {
                FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, false, false);
                if (fHTreeStateNode != null) {
                    FHTreeStateNode fHTreeStateNode2 = (FHTreeStateNode)fHTreeStateNode.getParent();
                    int n = fHTreeStateNode.getRow();
                    boolean bl = fHTreeStateNode.isExpanded();
                    boolean bl2 = fHTreeStateNode.isVisible();
                    if (bl2 && bl) {
                        fHTreeStateNode.collapse(true);
                        fHTreeStateNode.removeFromParent();
                        fHTreeStateNode = this.getNodeForPath(treePath, false, true);
                        fHTreeStateNode.expand();
                    } else {
                        fHTreeStateNode.removeFromParent();
                    }
                    if (this.treeSelectionModel != null && bl2 && bl) {
                        this.treeSelectionModel.resetRowSelection();
                    }
                    if (bl2) {
                        this.visibleNodesChanged();
                    }
                }
            }
        }
    }

    private void visibleNodesChanged() {
    }

    private class FHTreeStateNode
    extends DefaultMutableTreeNode {
        protected boolean isExpanded;
        protected int childIndex;
        protected int row;
        protected TreePath path;

        public FHTreeStateNode(Object object, int n, int n2) {
            super(object);
            this.childIndex = n;
            this.row = n2;
        }

        protected void addNode(FHTreeStateNode fHTreeStateNode) {
            boolean bl = false;
            int n = fHTreeStateNode.getChildIndex();
            int n2 = 0;
            int n3 = this.getChildCount();
            while (n2 < n3) {
                if (((FHTreeStateNode)this.getChildAt(n2)).getChildIndex() > n) {
                    bl = true;
                    this.insert(fHTreeStateNode, n2);
                    n2 = n3;
                }
                ++n2;
            }
            if (!bl) {
                this.add(fHTreeStateNode);
            }
        }

        protected void adjustChildIndexs(int n, int n2) {
            int n3 = n;
            int n4 = this.getChildCount();
            while (n3 < n4) {
                ((FHTreeStateNode)this.getChildAt((int)n3)).childIndex += n2;
                ++n3;
            }
        }

        protected void adjustRowBy(int n) {
            this.row += n;
            if (this.isExpanded) {
                int n2 = this.getChildCount() - 1;
                while (n2 >= 0) {
                    ((FHTreeStateNode)this.getChildAt(n2)).adjustRowBy(n);
                    --n2;
                }
            }
        }

        protected void adjustRowBy(int n, int n2) {
            FHTreeStateNode fHTreeStateNode;
            if (this.isExpanded) {
                int n3 = this.getChildCount() - 1;
                while (n3 >= n2) {
                    ((FHTreeStateNode)this.getChildAt(n3)).adjustRowBy(n);
                    --n3;
                }
            }
            if ((fHTreeStateNode = (FHTreeStateNode)this.getParent()) != null) {
                fHTreeStateNode.adjustRowBy(n, fHTreeStateNode.getIndex(this) + 1);
            }
        }

        protected void childInsertedAtModelIndex(int n, boolean bl) {
            int n2 = this.getChildCount();
            int n3 = 0;
            while (n3 < n2) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(n3);
                if (fHTreeStateNode.childIndex >= n) {
                    if (bl) {
                        this.adjustRowBy(1, n3);
                        FixedHeightLayoutCache.this.adjustRowCountBy(1);
                    }
                    while (n3 < n2) {
                        ++((FHTreeStateNode)this.getChildAt((int)n3)).childIndex;
                        ++n3;
                    }
                    return;
                }
                ++n3;
            }
            if (bl) {
                this.adjustRowBy(1, n2);
                FixedHeightLayoutCache.this.adjustRowCountBy(1);
            }
        }

        protected void collapse(boolean bl) {
            if (this.isExpanded) {
                int n;
                TreePath[] treePathArray = FixedHeightLayoutCache.this.treeSelectionModel != null ? FixedHeightLayoutCache.this.treeSelectionModel.getSelectionPaths() : null;
                if (this.isVisible() && bl) {
                    n = this.getTotalChildCount();
                    this.isExpanded = false;
                    FixedHeightLayoutCache.this.adjustRowCountBy(-n);
                    this.adjustRowBy(-n, 0);
                } else {
                    this.isExpanded = false;
                }
                if (treePathArray != null) {
                    n = 0;
                    TreePath treePath = this.getTreePath();
                    int n2 = treePathArray.length - 1;
                    while (n2 >= 0) {
                        if (treePathArray[n2] != null && treePath.isDescendant(treePathArray[n2]) && !treePath.equals(treePathArray[n2])) {
                            n = 1;
                        } else {
                            treePathArray[n2] = null;
                        }
                        --n2;
                    }
                    if (n != 0) {
                        FixedHeightLayoutCache.this.treeSelectionModel.removeSelectionPaths(treePathArray);
                    }
                }
                if (bl && this.isVisible()) {
                    FixedHeightLayoutCache.this.treeSelectionModel.resetRowSelection();
                }
            }
        }

        protected FHTreeStateNode createChildFor(Object object) {
            int n = FixedHeightLayoutCache.this.treeModel.getIndexOfChild(this.getUserObject(), object);
            if (n < 0) {
                return null;
            }
            FHTreeStateNode fHTreeStateNode = FixedHeightLayoutCache.this.createNodeForValue(object, n);
            int n2 = this.isVisible() ? this.getRowToModelIndex(n) : -1;
            fHTreeStateNode.row = n2;
            int n3 = 0;
            int n4 = this.getChildCount();
            while (n3 < n4) {
                FHTreeStateNode fHTreeStateNode2 = (FHTreeStateNode)this.getChildAt(n3);
                if (fHTreeStateNode2.childIndex > n) {
                    this.insert(fHTreeStateNode, n3);
                    return fHTreeStateNode;
                }
                ++n3;
            }
            this.add(fHTreeStateNode);
            return fHTreeStateNode;
        }

        protected void didAdjustTree() {
        }

        protected void didExpand() {
            int n = this.setRowAndChildren(this.row);
            FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
            int n2 = n - this.row - 1;
            if (fHTreeStateNode != null) {
                fHTreeStateNode.adjustRowBy(n2, fHTreeStateNode.getIndex(this) + 1);
            }
            FixedHeightLayoutCache.this.adjustRowCountBy(n2);
        }

        protected void expand() {
            if (!this.isExpanded) {
                boolean bl = this.isVisible();
                this.isExpanded = true;
                if (bl) {
                    this.didExpand();
                }
                if (bl && FixedHeightLayoutCache.this.treeSelectionModel != null) {
                    FixedHeightLayoutCache.this.treeSelectionModel.resetRowSelection();
                }
            }
        }

        protected void expandParentAndReceiver() {
            FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
            if (fHTreeStateNode != null) {
                fHTreeStateNode.expandParentAndReceiver();
            }
            this.expand();
        }

        public FHTreeStateNode getChildAtModelIndex(int n) {
            int n2 = this.getChildCount() - 1;
            while (n2 >= 0) {
                if (((FHTreeStateNode)this.getChildAt((int)n2)).childIndex == n) {
                    return (FHTreeStateNode)this.getChildAt(n2);
                }
                --n2;
            }
            return null;
        }

        public int getChildIndex() {
            return this.childIndex;
        }

        protected int getCountTo(int n) {
            int n2 = n + 1;
            int n3 = 0;
            int n4 = this.getChildCount();
            while (n3 < n4) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(n3);
                if (fHTreeStateNode.childIndex >= n) {
                    n3 = n4;
                } else {
                    n2 += fHTreeStateNode.getTotalChildCount();
                }
                ++n3;
            }
            if (this.parent != null) {
                return n2 + ((FHTreeStateNode)this.getParent()).getCountTo(this.childIndex);
            }
            if (!FixedHeightLayoutCache.this.isRootVisible()) {
                return n2 - 1;
            }
            return n2;
        }

        protected int getNumExpandedChildrenTo(int n) {
            int n2 = n;
            int n3 = 0;
            int n4 = this.getChildCount();
            while (n3 < n4) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(n3);
                if (fHTreeStateNode.childIndex >= n) {
                    return n2;
                }
                n2 += fHTreeStateNode.getTotalChildCount();
                ++n3;
            }
            return n2;
        }

        protected boolean getPathForRow(int n, int n2, SearchInfo searchInfo) {
            if (this.row == n) {
                searchInfo.node = this;
                searchInfo.isNodeParentNode = false;
                searchInfo.childIndex = this.childIndex;
                return true;
            }
            FHTreeStateNode fHTreeStateNode = null;
            int n3 = 0;
            int n4 = this.getChildCount();
            while (n3 < n4) {
                FHTreeStateNode fHTreeStateNode2 = (FHTreeStateNode)this.getChildAt(n3);
                if (fHTreeStateNode2.row > n) {
                    if (n3 == 0) {
                        searchInfo.node = this;
                        searchInfo.isNodeParentNode = true;
                        searchInfo.childIndex = n - this.row - 1;
                        return true;
                    }
                    int n5 = 1 + fHTreeStateNode2.row - (fHTreeStateNode2.childIndex - fHTreeStateNode.childIndex);
                    if (n < n5) {
                        return fHTreeStateNode.getPathForRow(n, n5, searchInfo);
                    }
                    searchInfo.node = this;
                    searchInfo.isNodeParentNode = true;
                    searchInfo.childIndex = n - n5 + fHTreeStateNode.childIndex + 1;
                    return true;
                }
                fHTreeStateNode = fHTreeStateNode2;
                ++n3;
            }
            int n6 = FixedHeightLayoutCache.this.treeModel.getChildCount(this.getUserObject());
            if (fHTreeStateNode != null) {
                int n7 = n2 - (n6 - fHTreeStateNode.childIndex) + 1;
                if (n < n7) {
                    return fHTreeStateNode.getPathForRow(n, n7, searchInfo);
                }
                searchInfo.node = this;
                searchInfo.isNodeParentNode = true;
                searchInfo.childIndex = n - n7 + fHTreeStateNode.childIndex + 1;
                return true;
            }
            int n8 = n - this.row - 1;
            if (n8 >= n6) {
                return false;
            }
            searchInfo.node = this;
            searchInfo.isNodeParentNode = true;
            searchInfo.childIndex = n8;
            return true;
        }

        public int getRow() {
            return this.row;
        }

        public int getRowToModelIndex(int n) {
            int n2;
            int n3 = n2 = this.getRow() + 1;
            int n4 = 0;
            int n5 = this.getChildCount();
            while (n4 < n5) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(n4);
                if (fHTreeStateNode.childIndex >= n) {
                    if (fHTreeStateNode.childIndex == n) {
                        return fHTreeStateNode.row;
                    }
                    if (n4 == 0) {
                        return this.getRow() + 1 + n;
                    }
                    return fHTreeStateNode.row - (fHTreeStateNode.childIndex - n);
                }
                ++n4;
            }
            return this.getRow() + 1 + this.getTotalChildCount() - (FixedHeightLayoutCache.this.treeModel.getChildCount(this.getUserObject()) - n);
        }

        public int getTotalChildCount() {
            if (this.isExpanded()) {
                int n;
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
                if (fHTreeStateNode != null && (n = fHTreeStateNode.getIndex(this)) + 1 < fHTreeStateNode.getChildCount()) {
                    FHTreeStateNode fHTreeStateNode2 = (FHTreeStateNode)fHTreeStateNode.getChildAt(n + 1);
                    return fHTreeStateNode2.row - this.row - (fHTreeStateNode2.childIndex - this.childIndex);
                }
                int n2 = FixedHeightLayoutCache.this.getModel().getChildCount(this.getUserObject());
                int n3 = this.getChildCount() - 1;
                while (n3 >= 0) {
                    n2 += ((FHTreeStateNode)this.getChildAt(n3)).getTotalChildCount();
                    --n3;
                }
                return n2;
            }
            return 0;
        }

        public TreePath getTreePath() {
            return this.path;
        }

        public int getVisibleLevel() {
            if (FixedHeightLayoutCache.this.isRootVisible()) {
                return this.getLevel();
            }
            return this.getLevel() - 1;
        }

        public boolean isExpanded() {
            return this.isExpanded;
        }

        public boolean isVisible() {
            FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
            if (fHTreeStateNode == null) {
                return true;
            }
            return fHTreeStateNode.isExpanded() && fHTreeStateNode.isVisible();
        }

        protected void makeVisible() {
            FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
            if (fHTreeStateNode != null) {
                fHTreeStateNode.expandParentAndReceiver();
            }
        }

        public void remove(int n) {
            FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(n);
            fHTreeStateNode.removeFromMapping();
            super.remove(n);
        }

        protected void removeChildAtModelIndex(int n, boolean bl) {
            FHTreeStateNode fHTreeStateNode = this.getChildAtModelIndex(n);
            if (fHTreeStateNode != null) {
                int n2 = fHTreeStateNode.getRow();
                int n3 = this.getIndex(fHTreeStateNode);
                fHTreeStateNode.collapse(false);
                this.remove(n3);
                this.adjustChildIndexs(n3, -1);
                if (bl) {
                    this.resetChildrenRowsFrom(n2, n3, n);
                }
            } else {
                int n4 = this.getChildCount();
                int n5 = 0;
                while (n5 < n4) {
                    FHTreeStateNode fHTreeStateNode2 = (FHTreeStateNode)this.getChildAt(n5);
                    if (fHTreeStateNode2.childIndex >= n) {
                        if (bl) {
                            this.adjustRowBy(-1, n5);
                            FixedHeightLayoutCache.this.adjustRowCountBy(-1);
                        }
                        while (n5 < n4) {
                            --((FHTreeStateNode)this.getChildAt((int)n5)).childIndex;
                            ++n5;
                        }
                        return;
                    }
                    ++n5;
                }
                if (bl) {
                    this.adjustRowBy(-1, n4);
                    FixedHeightLayoutCache.this.adjustRowCountBy(-1);
                }
            }
        }

        protected void removeFromMapping() {
            if (this.path != null) {
                FixedHeightLayoutCache.this.removeMapping(this);
                int n = this.getChildCount() - 1;
                while (n >= 0) {
                    ((FHTreeStateNode)this.getChildAt(n)).removeFromMapping();
                    --n;
                }
            }
        }

        protected void resetChildrenPaths(TreePath treePath) {
            FixedHeightLayoutCache.this.removeMapping(this);
            this.path = treePath == null ? new TreePath(this.getUserObject()) : treePath.pathByAddingChild(this.getUserObject());
            FixedHeightLayoutCache.this.addMapping(this);
            int n = this.getChildCount() - 1;
            while (n >= 0) {
                ((FHTreeStateNode)this.getChildAt(n)).resetChildrenPaths(this.path);
                --n;
            }
        }

        protected void resetChildrenRowsFrom(int n, int n2, int n3) {
            FHTreeStateNode fHTreeStateNode;
            int n4 = n;
            int n5 = n3;
            int n6 = this.getChildCount();
            int n7 = n2;
            while (n7 < n6) {
                fHTreeStateNode = (FHTreeStateNode)this.getChildAt(n7);
                n4 += fHTreeStateNode.childIndex - n5;
                n5 = fHTreeStateNode.childIndex + 1;
                if (fHTreeStateNode.isExpanded) {
                    n4 = fHTreeStateNode.setRowAndChildren(n4);
                } else {
                    fHTreeStateNode.row = n4++;
                }
                ++n7;
            }
            n4 += FixedHeightLayoutCache.this.treeModel.getChildCount(this.getUserObject()) - n5;
            fHTreeStateNode = (FHTreeStateNode)this.getParent();
            if (fHTreeStateNode != null) {
                fHTreeStateNode.resetChildrenRowsFrom(n4, fHTreeStateNode.getIndex(this) + 1, this.childIndex + 1);
            } else {
                FixedHeightLayoutCache.this.rowCount = n4;
            }
        }

        public void setParent(MutableTreeNode mutableTreeNode) {
            super.setParent(mutableTreeNode);
            if (mutableTreeNode != null) {
                this.path = ((FHTreeStateNode)mutableTreeNode).getTreePath().pathByAddingChild(this.getUserObject());
                FixedHeightLayoutCache.this.addMapping(this);
            }
        }

        protected int setRowAndChildren(int n) {
            this.row = n;
            if (!this.isExpanded()) {
                return this.row + 1;
            }
            int n2 = this.row + 1;
            int n3 = 0;
            int n4 = this.getChildCount();
            int n5 = 0;
            while (n5 < n4) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(n5);
                n2 += fHTreeStateNode.childIndex - n3;
                n3 = fHTreeStateNode.childIndex + 1;
                if (fHTreeStateNode.isExpanded) {
                    n2 = fHTreeStateNode.setRowAndChildren(n2);
                } else {
                    fHTreeStateNode.row = n2++;
                }
                ++n5;
            }
            return n2 + FixedHeightLayoutCache.this.treeModel.getChildCount(this.getUserObject()) - n3;
        }

        public void setUserObject(Object object) {
            super.setUserObject(object);
            if (this.path != null) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
                if (fHTreeStateNode != null) {
                    this.resetChildrenPaths(fHTreeStateNode.getTreePath());
                } else {
                    this.resetChildrenPaths(null);
                }
            }
        }
    }

    private class SearchInfo {
        protected FHTreeStateNode node;
        protected boolean isNodeParentNode;
        protected int childIndex;

        SearchInfo() {
        }

        protected TreePath getPath() {
            if (this.node == null) {
                return null;
            }
            if (this.isNodeParentNode) {
                return this.node.getTreePath().pathByAddingChild(FixedHeightLayoutCache.this.treeModel.getChild(this.node.getUserObject(), this.childIndex));
            }
            return this.node.path;
        }
    }

    private class VisibleFHTreeStateNodeEnumeration
    implements Enumeration {
        protected FHTreeStateNode parent;
        protected int nextIndex;
        protected int childCount;

        protected VisibleFHTreeStateNodeEnumeration(FHTreeStateNode fHTreeStateNode) {
            this(fHTreeStateNode, -1);
        }

        protected VisibleFHTreeStateNodeEnumeration(FHTreeStateNode fHTreeStateNode, int n) {
            this.parent = fHTreeStateNode;
            this.nextIndex = n;
            this.childCount = FixedHeightLayoutCache.this.treeModel.getChildCount(this.parent.getUserObject());
        }

        /*
         * Unable to fully structure code
         */
        protected boolean findNextValidParent() {
            if (this.parent != FixedHeightLayoutCache.access$6(FixedHeightLayoutCache.this)) ** GOTO lbl12
            this.parent = null;
            return false;
lbl-1000:
            // 1 sources

            {
                var1_1 = (FHTreeStateNode)this.parent.getParent();
                if (var1_1 != null) {
                    this.nextIndex = this.parent.childIndex;
                    this.parent = var1_1;
                    this.childCount = FixedHeightLayoutCache.this.treeModel.getChildCount(this.parent.getUserObject());
                    if (!this.updateNextIndex()) continue;
                    return true;
                }
                this.parent = null;
lbl12:
                // 3 sources

                ** while (this.parent != null)
            }
lbl13:
            // 1 sources

            return false;
        }

        public boolean hasMoreElements() {
            return this.parent != null;
        }

        public Object nextElement() {
            FHTreeStateNode fHTreeStateNode;
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("No more visible paths");
            }
            TreePath treePath = this.nextIndex == -1 ? this.parent.getTreePath() : ((fHTreeStateNode = this.parent.getChildAtModelIndex(this.nextIndex)) == null ? this.parent.getTreePath().pathByAddingChild(FixedHeightLayoutCache.this.treeModel.getChild(this.parent.getUserObject(), this.nextIndex)) : fHTreeStateNode.getTreePath());
            this.updateNextObject();
            return treePath;
        }

        protected boolean updateNextIndex() {
            if (this.nextIndex == -1 && !this.parent.isExpanded()) {
                return false;
            }
            if (this.childCount == 0) {
                return false;
            }
            if (++this.nextIndex >= this.childCount) {
                return false;
            }
            FHTreeStateNode fHTreeStateNode = this.parent.getChildAtModelIndex(this.nextIndex);
            if (fHTreeStateNode != null && fHTreeStateNode.isExpanded()) {
                this.parent = fHTreeStateNode;
                this.nextIndex = -1;
                this.childCount = FixedHeightLayoutCache.this.treeModel.getChildCount(fHTreeStateNode.getUserObject());
            }
            return true;
        }

        protected void updateNextObject() {
            if (!this.updateNextIndex()) {
                this.findNextValidParent();
            }
        }
    }
}

