/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html.parser;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.text.html.parser.AttributeList;
import javax.swing.text.html.parser.ContentModel;
import javax.swing.text.html.parser.DTDConstants;
import javax.swing.text.html.parser.Element;
import javax.swing.text.html.parser.Entity;

public class DTD
implements DTDConstants {
    public String name;
    public Vector elements = new Vector();
    public Hashtable elementHash = new Hashtable();
    public Hashtable entityHash = new Hashtable();
    public final Element pcdata = this.getElement("#pcdata");
    public final Element html = this.getElement("html");
    public final Element meta = this.getElement("meta");
    public final Element base = this.getElement("base");
    public final Element isindex = this.getElement("isindex");
    public final Element head = this.getElement("head");
    public final Element body = this.getElement("body");
    public final Element applet = this.getElement("applet");
    public final Element param = this.getElement("param");
    public final Element p = this.getElement("p");
    public final Element title = this.getElement("title");
    public static int FILE_VERSION = 1;
    static Hashtable dtdHash = new Hashtable();

    protected DTD(String string) {
        this.name = string;
        this.defEntity("#RE", 65536, 13);
        this.defEntity("#RS", 65536, 10);
        this.defEntity("#SPACE", 65536, 32);
        this.defineElement("unknown", 17, false, true, null, null, null, null);
    }

    protected AttributeList defAttributeList(String string, int n, int n2, String string2, String string3, AttributeList attributeList) {
        Vector<String> vector = null;
        if (string3 != null) {
            vector = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.length() <= 0) continue;
                vector.addElement(string4);
            }
        }
        return new AttributeList(string, n, n2, string2, vector, attributeList);
    }

    protected ContentModel defContentModel(int n, Object object, ContentModel contentModel) {
        return new ContentModel(n, object, contentModel);
    }

    protected Element defElement(String string, int n, boolean bl, boolean bl2, ContentModel contentModel, String[] stringArray, String[] stringArray2, AttributeList attributeList) {
        BitSet bitSet = null;
        if (stringArray != null && stringArray.length > 0) {
            bitSet = new BitSet();
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string2 = stringArray[n2];
                if (string2.length() > 0) {
                    bitSet.set(this.getElement(string2).getIndex());
                }
                ++n2;
            }
        }
        BitSet bitSet2 = null;
        if (stringArray2 != null && stringArray2.length > 0) {
            bitSet2 = new BitSet();
            int n3 = 0;
            while (n3 < stringArray2.length) {
                String string3 = stringArray2[n3];
                if (string3.length() > 0) {
                    bitSet2.set(this.getElement(string3).getIndex());
                }
                ++n3;
            }
        }
        return this.defineElement(string, n, bl, bl2, contentModel, bitSet, bitSet2, attributeList);
    }

    public Entity defEntity(String string, int n, int n2) {
        char[] cArray = new char[]{(char)n2};
        return this.defineEntity(string, n, cArray);
    }

    protected Entity defEntity(String string, int n, String string2) {
        int n2 = string2.length();
        char[] cArray = new char[n2];
        string2.getChars(0, n2, cArray, 0);
        return this.defineEntity(string, n, cArray);
    }

    public void defineAttributes(String string, AttributeList attributeList) {
        Element element = this.getElement(string);
        element.atts = attributeList;
    }

    public Element defineElement(String string, int n, boolean bl, boolean bl2, ContentModel contentModel, BitSet bitSet, BitSet bitSet2, AttributeList attributeList) {
        Element element = this.getElement(string);
        element.type = n;
        element.oStart = bl;
        element.oEnd = bl2;
        element.content = contentModel;
        element.exclusions = bitSet;
        element.inclusions = bitSet2;
        element.atts = attributeList;
        return element;
    }

    public Entity defineEntity(String string, int n, char[] cArray) {
        Entity entity = (Entity)this.entityHash.get(string);
        if (entity == null) {
            entity = new Entity(string, n, cArray);
            this.entityHash.put(string, entity);
            if ((n & 0x10000) != 0 && cArray.length == 1) {
                switch (n & 0xFFFEFFFF) {
                    case 1: 
                    case 11: {
                        this.entityHash.put(new Integer(cArray[0]), entity);
                        break;
                    }
                }
            }
        }
        return entity;
    }

    boolean elementExists(String string) {
        Element element = (Element)this.elementHash.get(string);
        return element != null;
    }

    public static DTD getDTD(String string) throws IOException {
        DTD dTD = (DTD)dtdHash.get(string = string.toLowerCase());
        if (dTD == null) {
            dTD = new DTD(string);
        }
        return dTD;
    }

    public Element getElement(int n) {
        return (Element)this.elements.elementAt(n);
    }

    public Element getElement(String string) {
        Element element = (Element)this.elementHash.get(string);
        if (element == null) {
            element = new Element(string, this.elements.size());
            this.elements.addElement(element);
            this.elementHash.put(string, element);
        }
        return element;
    }

    public Entity getEntity(int n) {
        return (Entity)this.entityHash.get(new Integer(n));
    }

    public Entity getEntity(String string) {
        return (Entity)this.entityHash.get(string);
    }

    public String getName() {
        return this.name;
    }

    public static void putDTDHash(String string, DTD dTD) {
        dtdHash.put(string, dTD);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        short s;
        int n;
        dataInputStream.readInt();
        String[] stringArray = new String[dataInputStream.readShort()];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = dataInputStream.readUTF();
            ++n2;
        }
        int n3 = dataInputStream.readShort();
        int n4 = 0;
        while (n4 < n3) {
            n = dataInputStream.readShort();
            s = dataInputStream.readByte();
            String string = dataInputStream.readUTF();
            this.defEntity(stringArray[n], s | 0x10000, string);
            ++n4;
        }
        n3 = dataInputStream.readShort();
        n = 0;
        while (n < n3) {
            s = dataInputStream.readShort();
            byte by = dataInputStream.readByte();
            byte by2 = dataInputStream.readByte();
            ContentModel contentModel = this.readContentModel(dataInputStream, stringArray);
            String[] stringArray2 = this.readNameArray(dataInputStream, stringArray);
            String[] stringArray3 = this.readNameArray(dataInputStream, stringArray);
            AttributeList attributeList = this.readAttributeList(dataInputStream, stringArray);
            this.defElement(stringArray[s], by, (by2 & 1) != 0, (by2 & 2) != 0, contentModel, stringArray2, stringArray3, attributeList);
            ++n;
        }
    }

    private AttributeList readAttributeList(DataInputStream dataInputStream, String[] stringArray) throws IOException {
        AttributeList attributeList = null;
        int n = dataInputStream.readByte();
        while (n > 0) {
            short s = dataInputStream.readShort();
            byte by = dataInputStream.readByte();
            byte by2 = dataInputStream.readByte();
            short s2 = dataInputStream.readShort();
            String string = s2 == -1 ? null : stringArray[s2];
            Vector<String> vector = null;
            int n2 = dataInputStream.readShort();
            if (n2 > 0) {
                vector = new Vector<String>(n2);
                int n3 = 0;
                while (n3 < n2) {
                    vector.addElement(stringArray[dataInputStream.readShort()]);
                    ++n3;
                }
            }
            attributeList = new AttributeList(stringArray[s], by, by2, string, vector, attributeList);
            --n;
        }
        return attributeList;
    }

    private ContentModel readContentModel(DataInputStream dataInputStream, String[] stringArray) throws IOException {
        byte by = dataInputStream.readByte();
        switch (by) {
            case 0: {
                return null;
            }
            case 1: {
                byte by2 = dataInputStream.readByte();
                ContentModel contentModel = this.readContentModel(dataInputStream, stringArray);
                ContentModel contentModel2 = this.readContentModel(dataInputStream, stringArray);
                return this.defContentModel(by2, contentModel, contentModel2);
            }
            case 2: {
                byte by3 = dataInputStream.readByte();
                Element element = this.getElement(stringArray[dataInputStream.readShort()]);
                ContentModel contentModel = this.readContentModel(dataInputStream, stringArray);
                return this.defContentModel(by3, element, contentModel);
            }
        }
        throw new IOException("bad bdtd");
    }

    private String[] readNameArray(DataInputStream dataInputStream, String[] stringArray) throws IOException {
        int n = dataInputStream.readShort();
        if (n == 0) {
            return null;
        }
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = stringArray[dataInputStream.readShort()];
            ++n2;
        }
        return stringArray2;
    }

    public String toString() {
        return this.name;
    }
}

