/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DefaultTableColumnModel
implements TableColumnModel,
PropertyChangeListener,
ListSelectionListener,
Serializable {
    protected Vector tableColumns;
    protected ListSelectionModel selectionModel;
    protected int columnMargin;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    protected boolean columnSelectionAllowed;
    protected int totalColumnWidth;
    static /* synthetic */ Class class$javax$swing$event$TableColumnModelListener;

    public DefaultTableColumnModel() {
        this.tableColumns = new Vector();
        this.setSelectionModel(this.createSelectionModel());
        this.setColumnMargin(1);
        this.setColumnSelectionAllowed(false);
    }

    public void addColumn(TableColumn tableColumn) {
        if (tableColumn == null) {
            throw new IllegalArgumentException("Object is null");
        }
        this.tableColumns.addElement(tableColumn);
        tableColumn.addPropertyChangeListener(this);
        this.recalcWidthCache();
        this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.getColumnCount() - 1));
    }

    public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        this.listenerList.add(class$javax$swing$event$TableColumnModelListener != null ? class$javax$swing$event$TableColumnModelListener : (class$javax$swing$event$TableColumnModelListener = DefaultTableColumnModel.class$("javax.swing.event.TableColumnModelListener")), tableColumnModelListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    protected void fireColumnAdded(TableColumnModelEvent tableColumnModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$TableColumnModelListener != null ? class$javax$swing$event$TableColumnModelListener : DefaultTableColumnModel.class$("javax.swing.event.TableColumnModelListener"))) {
                ((TableColumnModelListener)objectArray[n + 1]).columnAdded(tableColumnModelEvent);
            }
            n -= 2;
        }
    }

    protected void fireColumnMarginChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$TableColumnModelListener != null ? class$javax$swing$event$TableColumnModelListener : DefaultTableColumnModel.class$("javax.swing.event.TableColumnModelListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((TableColumnModelListener)objectArray[n + 1]).columnMarginChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    protected void fireColumnMoved(TableColumnModelEvent tableColumnModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$TableColumnModelListener != null ? class$javax$swing$event$TableColumnModelListener : DefaultTableColumnModel.class$("javax.swing.event.TableColumnModelListener"))) {
                ((TableColumnModelListener)objectArray[n + 1]).columnMoved(tableColumnModelEvent);
            }
            n -= 2;
        }
    }

    protected void fireColumnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$TableColumnModelListener != null ? class$javax$swing$event$TableColumnModelListener : DefaultTableColumnModel.class$("javax.swing.event.TableColumnModelListener"))) {
                ((TableColumnModelListener)objectArray[n + 1]).columnRemoved(tableColumnModelEvent);
            }
            n -= 2;
        }
    }

    protected void fireColumnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$TableColumnModelListener != null ? class$javax$swing$event$TableColumnModelListener : DefaultTableColumnModel.class$("javax.swing.event.TableColumnModelListener"))) {
                ((TableColumnModelListener)objectArray[n + 1]).columnSelectionChanged(listSelectionEvent);
            }
            n -= 2;
        }
    }

    public TableColumn getColumn(int n) {
        return (TableColumn)this.tableColumns.elementAt(n);
    }

    public int getColumnCount() {
        return this.tableColumns.size();
    }

    public int getColumnIndex(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Identifier is null");
        }
        Enumeration enumeration = this.getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            if (object.equals(tableColumn.getIdentifier())) {
                return n;
            }
            ++n;
        }
        throw new IllegalArgumentException("Identifier not found");
    }

    public int getColumnIndexAtX(int n) {
        int n2 = 0;
        Point point = new Point(n, 1);
        Rectangle rectangle = new Rectangle(0, 0, 0, 3);
        Enumeration enumeration = this.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            rectangle.width = tableColumn.getWidth() + this.columnMargin;
            if (rectangle.contains(point)) {
                return n2;
            }
            rectangle.x += rectangle.width;
            ++n2;
        }
        return -1;
    }

    public int getColumnMargin() {
        return this.columnMargin;
    }

    public boolean getColumnSelectionAllowed() {
        return this.columnSelectionAllowed;
    }

    public Enumeration getColumns() {
        return this.tableColumns.elements();
    }

    public int getSelectedColumnCount() {
        if (this.selectionModel != null) {
            int n = this.selectionModel.getMinSelectionIndex();
            int n2 = this.selectionModel.getMaxSelectionIndex();
            int n3 = 0;
            int n4 = n;
            while (n4 <= n2) {
                if (this.selectionModel.isSelectedIndex(n4)) {
                    ++n3;
                }
                ++n4;
            }
            return n3;
        }
        return 0;
    }

    public int[] getSelectedColumns() {
        if (this.selectionModel != null) {
            int n = this.selectionModel.getMinSelectionIndex();
            int n2 = this.selectionModel.getMaxSelectionIndex();
            if (n == -1 || n2 == -1) {
                return new int[0];
            }
            int[] nArray = new int[1 + (n2 - n)];
            int n3 = 0;
            int n4 = n;
            while (n4 <= n2) {
                if (this.selectionModel.isSelectedIndex(n4)) {
                    nArray[n3++] = n4;
                }
                ++n4;
            }
            int[] nArray2 = new int[n3];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            return nArray2;
        }
        return new int[0];
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public int getTotalColumnWidth() {
        return this.totalColumnWidth;
    }

    public void moveColumn(int n, int n2) {
        if (n < 0 || n >= this.getColumnCount() || n2 < 0 || n2 >= this.getColumnCount()) {
            throw new IllegalArgumentException("moveColumn() - Index out of range");
        }
        if (n == n2) {
            return;
        }
        TableColumn tableColumn = (TableColumn)this.tableColumns.elementAt(n);
        boolean bl = false;
        if (this.selectionModel.isSelectedIndex(n)) {
            this.selectionModel.removeSelectionInterval(n, n);
            bl = true;
        }
        this.tableColumns.removeElementAt(n);
        this.tableColumns.insertElementAt(tableColumn, n2);
        if (bl) {
            this.selectionModel.addSelectionInterval(n2, n2);
        }
        this.fireColumnMoved(new TableColumnModelEvent(this, n, n2));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("columWidth".equals(string)) {
            this.recalcWidthCache();
        } else if (!"headerValue".equals(string) && !"headerRenderer".equals(string)) {
            "cellRenderer".equals(string);
        }
    }

    protected void recalcWidthCache() {
        Enumeration enumeration = this.getColumns();
        this.totalColumnWidth = 0;
        while (enumeration.hasMoreElements()) {
            this.totalColumnWidth += ((TableColumn)enumeration.nextElement()).getWidth() + this.columnMargin;
        }
    }

    public void removeColumn(TableColumn tableColumn) {
        int n = this.tableColumns.indexOf(tableColumn);
        if (n != -1) {
            if (this.selectionModel != null) {
                this.selectionModel.removeIndexInterval(n, n);
            }
            tableColumn.removePropertyChangeListener(this);
            this.tableColumns.removeElementAt(n);
            this.recalcWidthCache();
            this.fireColumnRemoved(new TableColumnModelEvent(this, this.getColumnCount() - 1, 0));
        }
    }

    public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        this.listenerList.remove(class$javax$swing$event$TableColumnModelListener != null ? class$javax$swing$event$TableColumnModelListener : (class$javax$swing$event$TableColumnModelListener = DefaultTableColumnModel.class$("javax.swing.event.TableColumnModelListener")), tableColumnModelListener);
    }

    public void setColumnMargin(int n) {
        if (n != this.columnMargin) {
            this.columnMargin = n;
            this.recalcWidthCache();
            this.fireColumnMarginChanged();
        }
    }

    public void setColumnSelectionAllowed(boolean bl) {
        this.columnSelectionAllowed = bl;
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        if (listSelectionModel != listSelectionModel2) {
            if (listSelectionModel2 != null) {
                listSelectionModel2.removeListSelectionListener(this);
            }
            this.selectionModel = listSelectionModel;
            if (listSelectionModel != null) {
                listSelectionModel.addListSelectionListener(this);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.fireColumnSelectionChanged(listSelectionEvent);
    }
}

