/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.JTextComponent;

public class BasicBorders {

    public static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected Color shadow;
        protected Color darkShadow;
        protected Color highlight;
        protected Color lightHighlight;

        public ButtonBorder(Color color, Color color2, Color color3, Color color4) {
            this.shadow = color;
            this.darkShadow = color2;
            this.highlight = color3;
            this.lightHighlight = color4;
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(3, 3, 3, 3);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = false;
            boolean bl2 = false;
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                ButtonModel buttonModel = abstractButton.getModel();
                boolean bl3 = bl = buttonModel.isPressed() && buttonModel.isArmed();
                if (component instanceof JButton) {
                    bl2 = ((JButton)component).isDefaultButton();
                }
            }
            BasicGraphicsUtils.drawBezel(graphics, n, n2, n3, n4, bl, bl2, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
        }
    }

    public static class ToggleButtonBorder
    extends ButtonBorder {
        public ToggleButtonBorder(Color color, Color color2, Color color3, Color color4) {
            super(color, color2, color3, color4);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(2, 2, 2, 2);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            BasicGraphicsUtils.drawBezel(graphics, n, n2, n3, n4, false, false, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
        }
    }

    public static class RadioButtonBorder
    extends ButtonBorder {
        public RadioButtonBorder(Color color, Color color2, Color color3, Color color4) {
            super(color, color2, color3, color4);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(2, 2, 2, 2);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                ButtonModel buttonModel = abstractButton.getModel();
                if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
                    BasicGraphicsUtils.drawLoweredBezel(graphics, n, n2, n3, n4, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
                } else {
                    BasicGraphicsUtils.drawBezel(graphics, n, n2, n3, n4, false, abstractButton.isFocusPainted() && abstractButton.hasFocus(), this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
                }
            } else {
                BasicGraphicsUtils.drawBezel(graphics, n, n2, n3, n4, false, false, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
            }
        }
    }

    public static class MenuBarBorder
    extends AbstractBorder
    implements UIResource {
        private Color shadow;
        private Color highlight;

        public MenuBarBorder(Color color, Color color2) {
            this.shadow = color;
            this.highlight = color2;
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 2, 0);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            BasicGraphicsUtils.drawGroove(graphics, 0, n4 - 2, n3, n4, this.shadow, this.highlight);
        }
    }

    public static class MarginBorder
    extends AbstractBorder
    implements UIResource {
        public Insets getBorderInsets(Component component) {
            Insets insets = null;
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                insets = abstractButton.getMargin();
            } else if (component instanceof JToolBar) {
                JToolBar jToolBar = (JToolBar)component;
                insets = jToolBar.getMargin();
            } else if (component instanceof JTextComponent) {
                JTextComponent jTextComponent = (JTextComponent)component;
                insets = jTextComponent.getMargin();
            }
            return insets != null ? insets : new Insets(0, 0, 0, 0);
        }
    }

    public static class FieldBorder
    extends AbstractBorder
    implements UIResource {
        protected Color shadow;
        protected Color darkShadow;
        protected Color highlight;
        protected Color lightHighlight;

        public FieldBorder(Color color, Color color2, Color color3, Color color4) {
            this.shadow = color;
            this.highlight = color3;
            this.darkShadow = color2;
            this.lightHighlight = color4;
        }

        public Insets getBorderInsets(Component component) {
            Insets insets = null;
            if (component instanceof JTextComponent) {
                insets = ((JTextComponent)component).getMargin();
            }
            if (insets != null) {
                return new Insets(2 + insets.top, 2 + insets.left, 2 + insets.bottom, 2 + insets.right);
            }
            return new Insets(2, 2, 2, 2);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            BasicGraphicsUtils.drawEtchedRect(graphics, n, n2, n3, n4, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
        }
    }

    public static class SplitPaneBorder
    implements Border,
    UIResource {
        protected Color highlight;
        protected Color shadow;

        public SplitPaneBorder(Color color, Color color2) {
            this.highlight = color;
            this.shadow = color2;
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JSplitPane jSplitPane = (JSplitPane)component;
            Component component2 = jSplitPane.getLeftComponent();
            if (jSplitPane.getOrientation() == 1) {
                Rectangle rectangle;
                if (component2 != null) {
                    rectangle = component2.getBounds();
                    graphics.setColor(this.shadow);
                    graphics.drawLine(0, 0, rectangle.width + 1, 0);
                    graphics.drawLine(0, 1, 0, rectangle.height + 2);
                    graphics.setColor(this.highlight);
                    graphics.drawLine(1, rectangle.height + 1, rectangle.width + 1, rectangle.height + 1);
                    graphics.drawLine(rectangle.width + 1, 1, rectangle.width + 1, rectangle.height + 2);
                }
                if ((component2 = jSplitPane.getRightComponent()) != null) {
                    rectangle = component2.getBounds();
                    int n5 = rectangle.x + rectangle.width;
                    int n6 = rectangle.y + rectangle.height;
                    graphics.setColor(this.shadow);
                    graphics.drawLine(rectangle.x - 1, 0, n5, 0);
                    graphics.drawLine(rectangle.x - 1, n6, rectangle.x, n6);
                    graphics.drawLine(rectangle.x - 1, 0, rectangle.x - 1, n6);
                    graphics.setColor(this.highlight);
                    graphics.drawLine(rectangle.x, n6, n5, n6);
                    graphics.drawLine(n5, 0, n5, n6 + 1);
                }
            } else {
                Rectangle rectangle;
                if (component2 != null) {
                    rectangle = component2.getBounds();
                    graphics.setColor(this.shadow);
                    graphics.drawLine(0, 0, rectangle.width + 1, 0);
                    graphics.drawLine(0, 1, 0, rectangle.height + 1);
                    graphics.setColor(this.highlight);
                    graphics.drawLine(1 + rectangle.width, 0, 1 + rectangle.width, rectangle.height + 1);
                    graphics.drawLine(0, rectangle.height + 1, rectangle.width, rectangle.height + 1);
                }
                if ((component2 = jSplitPane.getRightComponent()) != null) {
                    rectangle = component2.getBounds();
                    int n7 = rectangle.x + rectangle.width;
                    int n8 = rectangle.y + rectangle.height;
                    graphics.setColor(this.shadow);
                    graphics.drawLine(0, rectangle.y - 1, 0, n8);
                    graphics.drawLine(n7, rectangle.y - 1, n7, rectangle.y);
                    graphics.drawLine(0, rectangle.y - 1, rectangle.width, rectangle.y - 1);
                    graphics.setColor(this.highlight);
                    graphics.drawLine(0, n8, rectangle.width + 1, n8);
                    graphics.drawLine(n7, rectangle.y, n7, n8);
                }
            }
        }
    }
}

