/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.SwingUtilities;
import javax.swing.TimerQueue;
import javax.swing.event.EventListenerList;

public class Timer
implements Serializable {
    int initialDelay;
    int delay;
    boolean repeats = true;
    boolean coalesce = true;
    protected EventListenerList listenerList = new EventListenerList();
    boolean eventQueued = false;
    private static boolean logTimers;
    Runnable doPostEvent = null;
    long expirationTime;
    Timer nextTimer;
    boolean running;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public Timer(int n, ActionListener actionListener) {
        this.delay = n;
        this.initialDelay = n;
        this.doPostEvent = new DoPostEvent();
        this.addActionListener(actionListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = Timer.class$("java.awt.event.ActionListener")), actionListener);
    }

    synchronized void cancelEvent() {
        this.eventQueued = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : Timer.class$("java.awt.event.ActionListener"))) {
                ((ActionListener)objectArray[n + 1]).actionPerformed(actionEvent);
            }
            n -= 2;
        }
    }

    public int getDelay() {
        return this.delay;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public static boolean getLogTimers() {
        return logTimers;
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public boolean isRepeats() {
        return this.repeats;
    }

    public boolean isRunning() {
        return this.timerQueue().containsTimer(this);
    }

    synchronized void post() {
        if (!this.eventQueued) {
            this.eventQueued = true;
            SwingUtilities.invokeLater(this.doPostEvent);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = Timer.class$("java.awt.event.ActionListener")), actionListener);
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public void setCoalesce(boolean bl) {
        this.coalesce = bl;
    }

    public void setDelay(int n) {
        if (n < 0) {
            throw new RuntimeException("Invalid initial delay: " + n);
        }
        this.delay = n;
        if (this.isRunning()) {
            TimerQueue timerQueue = this.timerQueue();
            timerQueue.removeTimer(this);
            this.cancelEvent();
            timerQueue.addTimer(this, System.currentTimeMillis() + (long)n);
        }
    }

    public void setInitialDelay(int n) {
        if (n < 0) {
            throw new RuntimeException("Invalid initial delay: " + n);
        }
        this.initialDelay = n;
    }

    public static void setLogTimers(boolean bl) {
        logTimers = bl;
    }

    public void setRepeats(boolean bl) {
        this.repeats = bl;
    }

    public void start() {
        this.timerQueue().addTimer(this, System.currentTimeMillis() + (long)this.getInitialDelay());
    }

    public void stop() {
        this.timerQueue().removeTimer(this);
        this.cancelEvent();
    }

    TimerQueue timerQueue() {
        return TimerQueue.sharedInstance();
    }

    class DoPostEvent
    implements Runnable,
    Serializable {
        DoPostEvent() {
        }

        Timer getTimer() {
            return Timer.this;
        }

        public void run() {
            if (logTimers) {
                System.out.println("Timer ringing: " + Timer.this);
            }
            if (Timer.this.eventQueued) {
                Timer.this.fireActionPerformed(new ActionEvent(Timer.this, 0, null));
                Timer.this.cancelEvent();
            }
        }
    }
}

