/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class JTextArea
extends JTextComponent {
    private static final String uiClassID = "TextAreaUI";
    private int rows;
    private int columns;
    private int columnWidth;
    private int rowHeight;
    private boolean wrap;
    private boolean word;

    public JTextArea() {
        this(null, null, 0, 0);
    }

    public JTextArea(int n, int n2) {
        this(null, null, n, n2);
    }

    public JTextArea(String string) {
        this(null, string, 0, 0);
    }

    public JTextArea(String string, int n, int n2) {
        this(null, string, n, n2);
    }

    public JTextArea(Document document) {
        this(document, null, 0, 0);
    }

    public JTextArea(Document document, String string, int n, int n2) {
        this.rows = n;
        this.columns = n2;
        if (document == null) {
            document = this.createDefaultModel();
        }
        this.setDocument(document);
        if (string != null) {
            this.setText(string);
        }
    }

    public void append(String string) {
        block2: {
            Document document = this.getDocument();
            if (document == null) break block2;
            try {
                document.insertString(document.getLength(), string, null);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    protected Document createDefaultModel() {
        return new PlainDocument();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTextArea();
        }
        return this.accessibleContext;
    }

    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.columnWidth = fontMetrics.charWidth('m');
        }
        return this.columnWidth;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getLineCount() {
        int n;
        Element element = this.getDocument().getDefaultRootElement();
        Element element2 = element.getElement((n = element.getElementCount()) - 1);
        if (element2.getEndOffset() - element2.getStartOffset() > 1) {
            return n;
        }
        return n - 1;
    }

    public int getLineEndOffset(int n) throws BadLocationException {
        Element element = this.getDocument().getDefaultRootElement();
        if (n < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (n >= element.getElementCount()) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element element2 = element.getElement(n);
        return element2.getEndOffset();
    }

    public int getLineOfOffset(int n) throws BadLocationException {
        Document document = this.getDocument();
        if (n < 0) {
            throw new BadLocationException("Can't translate offset to line", -1);
        }
        if (n > document.getLength()) {
            throw new BadLocationException("Can't translate offset to line", document.getLength() + 1);
        }
        Element element = this.getDocument().getDefaultRootElement();
        return element.getElementIndex(n);
    }

    public int getLineStartOffset(int n) throws BadLocationException {
        Element element = this.getDocument().getDefaultRootElement();
        if (n < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (n >= element.getElementCount()) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element element2 = element.getElement(n);
        return element2.getStartOffset();
    }

    public boolean getLineWrap() {
        return this.wrap;
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = super.getPreferredScrollableViewportSize();
        dimension = dimension == null ? new Dimension(400, 400) : dimension;
        dimension.width = this.columns == 0 ? dimension.width : this.columns * this.getColumnWidth();
        dimension.height = this.rows == 0 ? dimension.height : this.rows * this.getRowHeight();
        return dimension;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = dimension = dimension == null ? new Dimension(400, 400) : dimension;
        if (this.columns != 0) {
            dimension.width = Math.max(dimension.width, this.columns * this.getColumnWidth());
        }
        if (this.rows != 0) {
            dimension.height = Math.max(dimension.height, this.rows * this.getRowHeight());
        }
        return dimension;
    }

    protected int getRowHeight() {
        if (this.rowHeight == 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.rowHeight = fontMetrics.getHeight();
        }
        return this.rowHeight;
    }

    public int getRows() {
        return this.rows;
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.wrap ? true : super.getScrollableTracksViewportWidth();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return this.getRowHeight();
            }
            case 0: {
                return this.getColumnWidth();
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    public int getTabSize() {
        Integer n;
        int n2 = 8;
        Document document = this.getDocument();
        if (document != null && (n = (Integer)document.getProperty("tabSize")) != null) {
            n2 = n;
        }
        return n2;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public boolean getWrapStyleWord() {
        return this.word;
    }

    public void insert(String string, int n) {
        Document document = this.getDocument();
        if (document != null) {
            try {
                document.insertString(n, string, null);
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException(badLocationException.getMessage());
            }
        }
    }

    public boolean isManagingFocus() {
        return true;
    }

    protected String paramString() {
        String string = this.wrap ? "true" : "false";
        String string2 = this.word ? "true" : "false";
        return String.valueOf(super.paramString()) + ",colums=" + this.columns + ",columWidth=" + this.columnWidth + ",rows=" + this.rows + ",rowHeight=" + this.rowHeight + ",word=" + string2 + ",wrap=" + string;
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
        super.processComponentKeyEvent(keyEvent);
        if (this.isManagingFocus() && (keyEvent.getKeyCode() == 9 || keyEvent.getKeyChar() == '\t')) {
            keyEvent.consume();
        }
    }

    public void replaceRange(String string, int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("end before start");
        }
        Document document = this.getDocument();
        if (document != null) {
            try {
                document.remove(n, n2 - n);
                document.insertString(n, string, null);
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException(badLocationException.getMessage());
            }
        }
    }

    public void setColumns(int n) {
        int n2 = this.columns;
        if (n < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        if (n != n2) {
            this.columns = n;
            this.invalidate();
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.rowHeight = 0;
        this.columnWidth = 0;
    }

    public void setLineWrap(boolean bl) {
        boolean bl2 = this.wrap;
        this.wrap = bl;
        this.firePropertyChange("LineWrap", bl2, bl);
    }

    public void setRows(int n) {
        int n2 = this.rows;
        if (n < 0) {
            throw new IllegalArgumentException("rows less than zero.");
        }
        if (n != n2) {
            this.rows = n;
            this.invalidate();
        }
    }

    public void setTabSize(int n) {
        Document document = this.getDocument();
        if (document != null) {
            int n2 = this.getTabSize();
            document.putProperty("tabSize", new Integer(n));
            this.firePropertyChange("TabSize", n2, n);
        }
    }

    public void setWrapStyleWord(boolean bl) {
        boolean bl2 = this.word;
        this.word = bl;
        this.firePropertyChange("WrapStyleWord", bl2, bl);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    protected class AccessibleJTextArea
    extends JTextComponent.AccessibleJTextComponent {
        protected AccessibleJTextArea() {
            super(JTextArea.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.MULTI_LINE);
            return accessibleStateSet;
        }
    }
}

