/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.MenuComponent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.plaf.DesktopIconUI;
import javax.swing.plaf.InternalFrameUI;

public class JInternalFrame
extends JComponent
implements Accessible,
WindowConstants,
RootPaneContainer {
    private static final String uiClassID = "InternalFrameUI";
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    protected boolean closable;
    protected boolean isClosed;
    protected boolean maximizable;
    protected boolean isMaximum;
    protected boolean iconable;
    protected boolean isIcon;
    protected boolean resizable;
    protected boolean isSelected;
    protected Icon frameIcon;
    protected String title;
    protected JDesktopIcon desktopIcon;
    private boolean opened;
    private int defaultCloseOperation = 1;
    public static final String CONTENT_PANE_PROPERTY = "contentPane";
    public static final String MENU_BAR_PROPERTY = "menuBar";
    public static final String TITLE_PROPERTY = "title";
    public static final String LAYERED_PANE_PROPERTY = "layeredPane";
    public static final String ROOT_PANE_PROPERTY = "rootPane";
    public static final String GLASS_PANE_PROPERTY = "glassPane";
    public static final String FRAME_ICON_PROPERTY = "frameIcon";
    public static final String IS_SELECTED_PROPERTY = "selected";
    public static final String IS_CLOSED_PROPERTY = "closed";
    public static final String IS_MAXIMUM_PROPERTY = "maximum";
    public static final String IS_ICON_PROPERTY = "icon";
    static /* synthetic */ Class class$javax$swing$event$InternalFrameListener;

    public JInternalFrame() {
        this("", false, false, false, false);
    }

    public JInternalFrame(String string) {
        this(string, false, false, false, false);
    }

    public JInternalFrame(String string, boolean bl) {
        this(string, bl, false, false, false);
    }

    public JInternalFrame(String string, boolean bl, boolean bl2) {
        this(string, bl, bl2, false, false);
    }

    public JInternalFrame(String string, boolean bl, boolean bl2, boolean bl3) {
        this(string, bl, bl2, bl3, false);
    }

    public JInternalFrame(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.setRootPane(this.createRootPane());
        this.setLayout(new BorderLayout());
        this.title = string;
        this.resizable = bl;
        this.closable = bl2;
        this.maximizable = bl3;
        this.isMaximum = false;
        this.iconable = bl4;
        this.isIcon = false;
        this.setRootPaneCheckingEnabled(true);
        this.desktopIcon = new JDesktopIcon(this);
        this.updateUI();
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("add");
        }
        super.addImpl(component, object, n);
    }

    public void addInternalFrameListener(InternalFrameListener internalFrameListener) {
        this.listenerList.add(class$javax$swing$event$InternalFrameListener != null ? class$javax$swing$event$InternalFrameListener : (class$javax$swing$event$InternalFrameListener = JInternalFrame.class$("javax.swing.event.InternalFrameListener")), internalFrameListener);
        this.enableEvents(0L);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    private Error createRootPaneException(String string) {
        String string2 = this.getClass().getName();
        return new Error("Do not use " + string2 + "." + string + "() use " + string2 + ".getContentPane()." + string + "() instead");
    }

    public void dispose() {
        if (this.isVisible()) {
            this.setVisible(false);
        }
        if (this.isSelected()) {
            try {
                this.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        if (!this.isClosed) {
            this.fireInternalFrameEvent(25550);
            this.fireInternalFrameEvent(25551);
        }
    }

    private void doDefaultCloseAction() {
        switch (this.defaultCloseOperation) {
            case 1: {
                try {
                    this.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
                break;
            }
            case 2: {
                try {
                    this.setClosed(true);
                    this.dispose();
                }
                catch (PropertyVetoException propertyVetoException) {}
                break;
            }
        }
    }

    protected void fireInternalFrameEvent(int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        AWTEvent aWTEvent = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$InternalFrameListener != null ? class$javax$swing$event$InternalFrameListener : JInternalFrame.class$("javax.swing.event.InternalFrameListener"))) {
                if (aWTEvent == null) {
                    aWTEvent = new InternalFrameEvent(this, n);
                }
                switch (aWTEvent.getID()) {
                    case 25549: {
                        ((InternalFrameListener)objectArray[n2 + 1]).internalFrameOpened((InternalFrameEvent)aWTEvent);
                        break;
                    }
                    case 25550: {
                        ((InternalFrameListener)objectArray[n2 + 1]).internalFrameClosing((InternalFrameEvent)aWTEvent);
                        this.doDefaultCloseAction();
                        break;
                    }
                    case 25551: {
                        ((InternalFrameListener)objectArray[n2 + 1]).internalFrameClosed((InternalFrameEvent)aWTEvent);
                        break;
                    }
                    case 25552: {
                        ((InternalFrameListener)objectArray[n2 + 1]).internalFrameIconified((InternalFrameEvent)aWTEvent);
                        break;
                    }
                    case 25553: {
                        ((InternalFrameListener)objectArray[n2 + 1]).internalFrameDeiconified((InternalFrameEvent)aWTEvent);
                        break;
                    }
                    case 25554: {
                        ((InternalFrameListener)objectArray[n2 + 1]).internalFrameActivated((InternalFrameEvent)aWTEvent);
                        break;
                    }
                    case 25555: {
                        ((InternalFrameListener)objectArray[n2 + 1]).internalFrameDeactivated((InternalFrameEvent)aWTEvent);
                        break;
                    }
                }
            }
            n2 -= 2;
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJInternalFrame();
        }
        return this.accessibleContext;
    }

    public Color getBackground() {
        return this.getContentPane().getBackground();
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public int getDefaultCloseOperation() {
        return this.defaultCloseOperation;
    }

    public JDesktopIcon getDesktopIcon() {
        return this.desktopIcon;
    }

    public JDesktopPane getDesktopPane() {
        Container container = this.getParent();
        while (container != null && !(container instanceof JDesktopPane)) {
            container = container.getParent();
        }
        if (container == null) {
            container = this.getDesktopIcon().getParent();
            while (container != null && !(container instanceof JDesktopPane)) {
                container = container.getParent();
            }
        }
        return (JDesktopPane)container;
    }

    public Color getForeground() {
        return this.getContentPane().getForeground();
    }

    public Icon getFrameIcon() {
        return this.frameIcon;
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getJMenuBar();
    }

    public int getLayer() {
        return JLayeredPane.getLayer(this);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public JMenuBar getMenuBar() {
        return this.getRootPane().getMenuBar();
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    public String getTitle() {
        return this.title;
    }

    public InternalFrameUI getUI() {
        return (InternalFrameUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public final String getWarningString() {
        return null;
    }

    public boolean isClosable() {
        return this.closable;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isIcon() {
        return this.isIcon;
    }

    public boolean isIconifiable() {
        return this.iconable;
    }

    public boolean isMaximizable() {
        return this.maximizable;
    }

    public boolean isMaximum() {
        return this.isMaximum;
    }

    public boolean isResizable() {
        return this.isMaximum ? false : this.resizable;
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void moveToBack() {
        if (this.getParent() != null && this.getParent() instanceof JLayeredPane) {
            JLayeredPane jLayeredPane = (JLayeredPane)this.getParent();
            jLayeredPane.moveToBack(this);
        }
    }

    public void moveToFront() {
        if (this.getParent() != null && this.getParent() instanceof JLayeredPane) {
            JLayeredPane jLayeredPane = (JLayeredPane)this.getParent();
            jLayeredPane.moveToFront(this);
        }
    }

    public void pack() {
        Container container = this.getParent();
        if (container != null && container.getPeer() == null) {
            container.addNotify();
            this.addNotify();
        }
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    protected String paramString() {
        String string;
        String string2 = this.rootPane != null ? this.rootPane.toString() : "";
        String string3 = this.rootPaneCheckingEnabled ? "true" : "false";
        String string4 = this.closable ? "true" : "false";
        String string5 = this.isClosed ? "true" : "false";
        String string6 = this.maximizable ? "true" : "false";
        String string7 = this.isMaximum ? "true" : "false";
        String string8 = this.iconable ? "true" : "false";
        String string9 = this.isIcon ? "true" : "false";
        String string10 = this.resizable ? "true" : "false";
        String string11 = this.isSelected ? "true" : "false";
        String string12 = this.frameIcon != null ? this.frameIcon.toString() : "";
        String string13 = this.title != null ? this.title : "";
        String string14 = this.desktopIcon != null ? this.desktopIcon.toString() : "";
        String string15 = string = this.opened ? "true" : "false";
        String string16 = this.defaultCloseOperation == 1 ? "HIDE_ON_CLOSE" : (this.defaultCloseOperation == 2 ? "DISPOSE_ON_CLOSE" : (this.defaultCloseOperation == 0 ? "DO_NOTHING_ON_CLOSE" : ""));
        return String.valueOf(super.paramString()) + ",closable=" + string4 + ",defaultCloseOperation=" + string16 + ",desktopIcon=" + string14 + ",frameIcon=" + string12 + ",iconable=" + string8 + ",isClosed=" + string5 + ",isIcon=" + string9 + ",isMaximum=" + string7 + ",isSelected=" + string11 + ",maximizable=" + string6 + ",opened=" + string + ",resizable=" + string10 + ",rootPane=" + string2 + ",rootPaneCheckingEnabled=" + string3 + ",title=" + string13;
    }

    public void removeInternalFrameListener(InternalFrameListener internalFrameListener) {
        this.listenerList.remove(class$javax$swing$event$InternalFrameListener != null ? class$javax$swing$event$InternalFrameListener : (class$javax$swing$event$InternalFrameListener = JInternalFrame.class$("javax.swing.event.InternalFrameListener")), internalFrameListener);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.validate();
        this.repaint();
    }

    public void setBackground(Color color) {
        this.getContentPane().setBackground(color);
    }

    public void setClosable(boolean bl) {
        this.closable = bl;
    }

    public void setClosed(boolean bl) throws PropertyVetoException {
        if (this.isClosed == bl) {
            return;
        }
        Boolean bl2 = this.isClosed ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.fireVetoableChange(IS_CLOSED_PROPERTY, bl2, bl3);
        this.isClosed = bl;
        if (this.isClosed) {
            this.fireInternalFrameEvent(25550);
            this.fireInternalFrameEvent(25551);
            this.opened = false;
        } else if (!this.opened) {
            this.fireInternalFrameEvent(25549);
            this.opened = true;
        }
        this.firePropertyChange(IS_CLOSED_PROPERTY, bl2, bl3);
    }

    public void setContentPane(Container container) {
        Container container2 = this.getContentPane();
        this.getRootPane().setContentPane(container);
        this.firePropertyChange(CONTENT_PANE_PROPERTY, container2, container);
    }

    public void setDefaultCloseOperation(int n) {
        this.defaultCloseOperation = n;
    }

    public void setDesktopIcon(JDesktopIcon jDesktopIcon) {
        this.desktopIcon = jDesktopIcon;
    }

    public void setForeground(Color color) {
        this.getContentPane().setForeground(color);
    }

    public void setFrameIcon(Icon icon) {
        Icon icon2 = this.frameIcon;
        this.frameIcon = icon;
        this.firePropertyChange(MENU_BAR_PROPERTY, icon2, icon);
    }

    public void setGlassPane(Component component) {
        Component component2 = this.getGlassPane();
        this.getRootPane().setGlassPane(component);
        this.firePropertyChange(GLASS_PANE_PROPERTY, component2, component);
    }

    public void setIcon(boolean bl) throws PropertyVetoException {
        if (this.isIcon == bl) {
            return;
        }
        Boolean bl2 = this.isIcon ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.fireVetoableChange(IS_ICON_PROPERTY, bl2, bl3);
        this.isIcon = bl;
        this.firePropertyChange(IS_ICON_PROPERTY, bl2, bl3);
        if (bl) {
            this.fireInternalFrameEvent(25552);
        } else {
            this.fireInternalFrameEvent(25553);
        }
    }

    public void setIconifiable(boolean bl) {
        this.iconable = bl;
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        JMenuBar jMenuBar2 = this.getMenuBar();
        this.getRootPane().setJMenuBar(jMenuBar);
        this.firePropertyChange(MENU_BAR_PROPERTY, jMenuBar2, jMenuBar);
    }

    public void setLayer(Integer n) {
        if (this.getParent() != null && this.getParent() instanceof JLayeredPane) {
            JLayeredPane jLayeredPane = (JLayeredPane)this.getParent();
            jLayeredPane.setLayer(this, n, jLayeredPane.getPosition(this));
        } else {
            JLayeredPane.putLayer(this, n);
            if (this.getParent() != null) {
                this.getParent().repaint(this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
            }
        }
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        JLayeredPane jLayeredPane2 = this.getLayeredPane();
        this.getRootPane().setLayeredPane(jLayeredPane);
        this.firePropertyChange(LAYERED_PANE_PROPERTY, jLayeredPane2, jLayeredPane);
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("setLayout");
        }
        super.setLayout(layoutManager);
    }

    public void setMaximizable(boolean bl) {
        this.maximizable = bl;
    }

    public void setMaximum(boolean bl) throws PropertyVetoException {
        if (this.isMaximum == bl) {
            return;
        }
        Boolean bl2 = this.isMaximum ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.fireVetoableChange(IS_MAXIMUM_PROPERTY, bl2, bl3);
        this.isMaximum = bl;
        this.firePropertyChange(IS_MAXIMUM_PROPERTY, bl2, bl3);
    }

    public void setMenuBar(JMenuBar jMenuBar) {
        JMenuBar jMenuBar2 = this.getMenuBar();
        this.getRootPane().setJMenuBar(jMenuBar);
        this.firePropertyChange(MENU_BAR_PROPERTY, jMenuBar2, jMenuBar);
    }

    public void setResizable(boolean bl) {
        this.resizable = bl;
    }

    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        JRootPane jRootPane2 = this.getRootPane();
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
            }
            finally {
                Object var5_4 = null;
                this.setRootPaneCheckingEnabled(bl);
            }
        }
        this.firePropertyChange(ROOT_PANE_PROPERTY, jRootPane2, jRootPane);
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    public void setSelected(boolean bl) throws PropertyVetoException {
        if (this.isSelected == bl) {
            return;
        }
        Boolean bl2 = this.isSelected ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.fireVetoableChange(IS_SELECTED_PROPERTY, bl2, bl3);
        this.isSelected = bl;
        this.firePropertyChange(IS_SELECTED_PROPERTY, bl2, bl3);
        if (this.isSelected) {
            this.fireInternalFrameEvent(25554);
        } else {
            this.fireInternalFrameEvent(25555);
        }
        this.repaint();
    }

    public void setTitle(String string) {
        String string2 = this.title;
        this.title = string;
        this.firePropertyChange(TITLE_PROPERTY, string2, string);
    }

    public void setUI(InternalFrameUI internalFrameUI) {
        boolean bl = this.isRootPaneCheckingEnabled();
        try {
            this.setRootPaneCheckingEnabled(false);
            super.setUI(internalFrameUI);
        }
        finally {
            Object var4_3 = null;
            this.setRootPaneCheckingEnabled(bl);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void show() {
        block6: {
            Container container = this.getParent();
            if (container != null && container.getPeer() == null) {
                container.addNotify();
                this.addNotify();
            }
            this.validate();
            if (!this.opened) {
                this.fireInternalFrameEvent(25549);
                this.opened = true;
            }
            if (this.isVisible()) {
                this.toFront();
            } else {
                super.show();
            }
            if (this.isSelected()) break block6;
            try {
                this.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    /*
     * Unable to fully structure code
     */
    synchronized void startModal() {
        block9: {
            if (this.isVisible() && !this.isShowing()) {
                var1_1 = this.getParent();
                while (var1_1 != null) {
                    if (!var1_1.isVisible()) {
                        var1_1.setVisible(true);
                    }
                    var1_1 = var1_1.getParent();
                }
            }
            try {
                if (!SwingUtilities.isEventDispatchThread()) ** GOTO lbl24
                var1_1 = this.getToolkit().getSystemEventQueue();
                while (this.isVisible()) {
                    var2_2 = var1_1.getNextEvent();
                    var3_3 = var2_2.getSource();
                    if (var3_3 instanceof Component) {
                        ((Component)var3_3).dispatchEvent(var2_2);
                        continue;
                    }
                    if (var3_3 instanceof MenuComponent) {
                        ((MenuComponent)var3_3).dispatchEvent(var2_2);
                        continue;
                    }
                    System.err.println("unable to dispatch event: " + var2_2);
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    this.wait();
lbl24:
                    // 2 sources

                    ** while (this.isVisible())
                }
lbl25:
                // 1 sources

            }
            catch (InterruptedException v0) {}
        }
    }

    synchronized void stopModal() {
        this.notifyAll();
    }

    public void toBack() {
        this.moveToBack();
    }

    public void toFront() {
        this.moveToFront();
    }

    public void updateUI() {
        this.setUI((InternalFrameUI)UIManager.getUI(this));
        this.invalidate();
        if (this.desktopIcon != null) {
            this.desktopIcon.updateUIWhenHidden();
        }
    }

    void updateUIWhenHidden() {
        this.setUI((InternalFrameUI)UIManager.getUI(this));
        this.invalidate();
        Component[] componentArray = this.getComponents();
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                SwingUtilities.updateComponentTreeUI(componentArray[n]);
                ++n;
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.ui.installUI(this);
            }
            finally {
                Object var4_3 = null;
                this.setRootPaneCheckingEnabled(bl);
            }
        }
    }

    protected class AccessibleJInternalFrame
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        protected AccessibleJInternalFrame() {
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return JInternalFrame.this.getTitle();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.INTERNAL_FRAME;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(JInternalFrame.this.getLayer());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(Integer.MAX_VALUE);
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(Integer.MIN_VALUE);
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                JInternalFrame.this.setLayer((Integer)number);
                return true;
            }
            return false;
        }
    }

    public static class JDesktopIcon
    extends JComponent
    implements Accessible {
        JInternalFrame internalFrame;

        public JDesktopIcon(JInternalFrame jInternalFrame) {
            this.setInternalFrame(jInternalFrame);
            this.updateUI();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleJDesktopIcon();
            }
            return this.accessibleContext;
        }

        public JDesktopPane getDesktopPane() {
            if (this.getInternalFrame() != null) {
                return this.getInternalFrame().getDesktopPane();
            }
            return null;
        }

        public JInternalFrame getInternalFrame() {
            return this.internalFrame;
        }

        public DesktopIconUI getUI() {
            return (DesktopIconUI)this.ui;
        }

        public String getUIClassID() {
            return "DesktopIconUI";
        }

        public void setInternalFrame(JInternalFrame jInternalFrame) {
            this.internalFrame = jInternalFrame;
        }

        public void setUI(DesktopIconUI desktopIconUI) {
            super.setUI(desktopIconUI);
        }

        public void updateUI() {
            boolean bl = this.ui != null;
            this.setUI((DesktopIconUI)UIManager.getUI(this));
            this.invalidate();
            Dimension dimension = this.getPreferredSize();
            this.setSize(dimension.width, dimension.height);
            if (this.internalFrame != null && this.internalFrame.getUI() != null) {
                SwingUtilities.updateComponentTreeUI(this.internalFrame);
            }
        }

        void updateUIWhenHidden() {
            this.setUI((DesktopIconUI)UIManager.getUI(this));
            this.invalidate();
            Component[] componentArray = this.getComponents();
            if (componentArray != null) {
                int n = 0;
                while (n < componentArray.length) {
                    SwingUtilities.updateComponentTreeUI(componentArray[n]);
                    ++n;
                }
            }
        }

        protected class AccessibleJDesktopIcon
        extends JComponent.AccessibleJComponent
        implements AccessibleValue {
            protected AccessibleJDesktopIcon() {
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.DESKTOP_ICON;
            }

            public AccessibleValue getAccessibleValue() {
                return this;
            }

            public Number getCurrentAccessibleValue() {
                AccessibleContext accessibleContext = JDesktopIcon.this.getInternalFrame().getAccessibleContext();
                AccessibleValue accessibleValue = accessibleContext.getAccessibleValue();
                if (accessibleValue != null) {
                    return accessibleValue.getCurrentAccessibleValue();
                }
                return null;
            }

            public Number getMaximumAccessibleValue() {
                AccessibleContext accessibleContext = JDesktopIcon.this.getInternalFrame().getAccessibleContext();
                if (accessibleContext instanceof AccessibleValue) {
                    return ((AccessibleValue)((Object)accessibleContext)).getMaximumAccessibleValue();
                }
                return null;
            }

            public Number getMinimumAccessibleValue() {
                AccessibleContext accessibleContext = JDesktopIcon.this.getInternalFrame().getAccessibleContext();
                if (accessibleContext instanceof AccessibleValue) {
                    return ((AccessibleValue)((Object)accessibleContext)).getMinimumAccessibleValue();
                }
                return null;
            }

            public boolean setCurrentAccessibleValue(Number number) {
                AccessibleContext accessibleContext = JDesktopIcon.this.getInternalFrame().getAccessibleContext();
                AccessibleValue accessibleValue = accessibleContext.getAccessibleValue();
                if (accessibleValue != null) {
                    return accessibleValue.setCurrentAccessibleValue(number);
                }
                return false;
            }
        }
    }
}

