/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AbstractWriter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class MinimalHTMLWriter
extends AbstractWriter {
    private static final int BOLD = 1;
    private static final int ITALIC = 2;
    private static final int UNDERLINE = 4;
    private int fontMask = 0;
    int startOffset = 0;
    int endOffset = 0;
    private AttributeSet fontAttributes;

    public MinimalHTMLWriter(Writer writer, StyledDocument styledDocument) {
        super(writer, styledDocument);
    }

    public MinimalHTMLWriter(Writer writer, StyledDocument styledDocument, int n, int n2) {
        super(writer, styledDocument, n, n2);
    }

    protected void endFontTag() throws IOException {
        this.write('\n');
        this.writeEndTag("</font>");
        this.fontAttributes = null;
    }

    protected boolean inFontTag() {
        return this.fontAttributes != null;
    }

    protected boolean isText(Element element) {
        return element.getName() == "content";
    }

    private void setFontMask(AttributeSet attributeSet) {
        if (StyleConstants.isBold(attributeSet)) {
            this.fontMask |= 1;
        }
        if (StyleConstants.isItalic(attributeSet)) {
            this.fontMask |= 2;
        }
        if (StyleConstants.isUnderline(attributeSet)) {
            this.fontMask |= 4;
        }
    }

    protected void startFontTag(String string) throws IOException {
        boolean bl = false;
        if (this.inFontTag()) {
            this.endFontTag();
            bl = true;
        }
        this.writeStartTag("<font style=\"" + string + "\">");
        if (bl) {
            this.indent();
        }
    }

    protected void text(Element element) throws IOException, BadLocationException {
        String string = this.getText(element);
        if (string.length() > 0 && string.charAt(string.length() - 1) == '\n') {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() > 0) {
            this.write(string);
        }
    }

    public void write() throws IOException, BadLocationException {
        this.writeStartTag("<html>");
        this.writeHeader();
        this.writeBody();
        this.writeEndTag("</html>");
    }

    protected void writeAttributes(AttributeSet attributeSet) throws IOException {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof StyleConstants.ParagraphConstants) && !(e instanceof StyleConstants.CharacterConstants) && !(e instanceof StyleConstants.FontConstants) && !(e instanceof StyleConstants.ColorConstants)) continue;
            this.indent();
            this.write(e.toString());
            this.write(':');
            this.write(attributeSet.getAttribute(e).toString());
            this.write(';');
            this.write('\n');
        }
    }

    protected void writeBody() throws IOException, BadLocationException {
        ElementIterator elementIterator = this.getElementIterator();
        elementIterator.current();
        Element element = null;
        this.writeStartTag("<body>");
        boolean bl = false;
        while ((element = elementIterator.next()) != null) {
            if (!this.inRange(element)) continue;
            if (element instanceof AbstractDocument.BranchElement) {
                if (bl) {
                    this.writeEndParagraph();
                    bl = false;
                    this.fontMask = 0;
                }
                this.writeStartParagraph(element);
                continue;
            }
            if (this.isText(element)) {
                this.writeContent(element, bl ^ true);
                bl = true;
                continue;
            }
            this.writeLeaf(element);
            bl = true;
        }
        if (bl) {
            this.writeEndParagraph();
        }
        this.writeEndTag("</body>");
    }

    protected void writeComponent(Element element) throws IOException {
    }

    protected void writeContent(Element element, boolean bl) throws IOException, BadLocationException {
        AttributeSet attributeSet = element.getAttributes();
        this.writeNonHTMLAttributes(attributeSet);
        if (bl) {
            this.indent();
        }
        this.writeHTMLTags(attributeSet);
        this.text(element);
    }

    private void writeEndMask(int n) throws IOException {
        if (n != 0) {
            if ((n & 1) != 0) {
                this.write("</b>");
            }
            if ((n & 2) != 0) {
                this.write("</i>");
            }
            if ((n & 4) != 0) {
                this.write("</u>");
            }
        }
    }

    protected void writeEndParagraph() throws IOException {
        this.writeEndMask(this.fontMask);
        if (this.inFontTag()) {
            this.endFontTag();
        } else {
            this.write('\n');
        }
        this.writeEndTag("</p>");
    }

    protected void writeEndTag(String string) throws IOException {
        this.decrIndent();
        this.indent();
        this.write(string);
        this.write('\n');
    }

    protected void writeHTMLTags(AttributeSet attributeSet) throws IOException {
        int n = this.fontMask;
        this.setFontMask(attributeSet);
        int n2 = 0;
        int n3 = 0;
        if ((n & 1) != 0) {
            if ((this.fontMask & 1) == 0) {
                n2 |= 1;
            }
        } else if ((this.fontMask & 1) != 0) {
            n3 |= 1;
        }
        if ((n & 2) != 0) {
            if ((this.fontMask & 2) == 0) {
                n2 |= 2;
            }
        } else if ((this.fontMask & 2) != 0) {
            n3 |= 2;
        }
        if ((n & 4) != 0) {
            if ((this.fontMask & 4) == 0) {
                n2 |= 4;
            }
        } else if ((this.fontMask & 4) != 0) {
            n3 |= 4;
        }
        this.writeEndMask(n2);
        this.writeStartMask(n3);
    }

    protected void writeHeader() throws IOException {
        this.writeStartTag("<head>");
        this.writeStartTag("<style>");
        this.writeStartTag("<!--");
        this.writeStyles();
        this.writeEndTag("-->");
        this.writeEndTag("</style>");
        this.writeEndTag("</head>");
    }

    protected void writeImage(Element element) throws IOException {
    }

    protected void writeLeaf(Element element) throws IOException {
        this.indent();
        if (element.getName() == "icon") {
            this.writeImage(element);
        } else if (element.getName() == "component") {
            this.writeComponent(element);
        }
    }

    protected void writeNonHTMLAttributes(AttributeSet attributeSet) throws IOException {
        String string;
        Integer n;
        String string2 = "";
        String string3 = "; ";
        if (this.inFontTag() && this.fontAttributes.isEqual(attributeSet)) {
            return;
        }
        Color color = (Color)attributeSet.getAttribute(StyleConstants.Foreground);
        if (color != null) {
            string2 = String.valueOf(string2) + "color: " + color + string3;
        }
        if ((n = (Integer)attributeSet.getAttribute(StyleConstants.FontSize)) != null) {
            string2 = String.valueOf(string2) + "font-size: " + n + string3;
        }
        if ((string = (String)attributeSet.getAttribute(StyleConstants.FontFamily)) != null) {
            string2 = String.valueOf(string2) + "font-family: " + string + string3;
        }
        if (string2.length() > 0) {
            this.startFontTag(string2);
            this.fontAttributes = attributeSet;
        }
    }

    private void writeStartMask(int n) throws IOException {
        if (n != 0) {
            if ((n & 4) != 0) {
                this.write("<u>");
            }
            if ((n & 2) != 0) {
                this.write("<i>");
            }
            if ((n & 1) != 0) {
                this.write("<b>");
            }
        }
    }

    protected void writeStartParagraph(Element element) throws IOException {
        AttributeSet attributeSet = element.getAttributes();
        Object object = attributeSet.getAttribute(StyleConstants.ResolveAttribute);
        if (object instanceof StyleContext.NamedStyle) {
            this.writeStartTag("<p class=" + ((StyleContext.NamedStyle)object).getName() + ">");
        } else {
            this.writeStartTag("<p>");
        }
    }

    protected void writeStartTag(String string) throws IOException {
        this.indent();
        this.write(string);
        this.write('\n');
        this.incrIndent();
    }

    protected void writeStyles() throws IOException {
        DefaultStyledDocument defaultStyledDocument = (DefaultStyledDocument)this.getDocument();
        Enumeration enumeration = defaultStyledDocument.getStyleNames();
        while (enumeration.hasMoreElements()) {
            Style style = defaultStyledDocument.getStyle((String)enumeration.nextElement());
            if (style.getAttributeCount() == 1 && style.isDefined(StyleConstants.NameAttribute)) continue;
            this.indent();
            this.write("p." + style.getName());
            this.write(" {\n");
            this.incrIndent();
            this.writeAttributes(style);
            this.decrIndent();
            this.indent();
            this.write("}\n");
        }
    }
}

