/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractAction;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ToolTipManager
extends MouseAdapter
implements MouseMotionListener {
    Timer enterTimer = new Timer(750, new insideTimerAction());
    Timer exitTimer;
    Timer insideTimer;
    String toolTipText;
    Point preferredLocation;
    JComponent insideComponent;
    MouseEvent mouseEvent;
    boolean showImmediately;
    static final ToolTipManager sharedInstance = new ToolTipManager();
    Popup tipWindow;
    JToolTip tip;
    private Rectangle popupRect = null;
    private Rectangle popupFrameRect = null;
    boolean enabled = true;
    boolean mouseAboveToolTip = false;
    private boolean tipShowing = false;
    private long timerEnter = 0L;
    private KeyStroke postTip;
    private KeyStroke hideTip;
    private AbstractAction postTipAction;
    private AbstractAction hideTipAction;
    private FocusListener focusChangeListener = null;
    protected boolean lightWeightPopupEnabled = true;
    protected boolean heavyWeightPopupEnabled = false;

    ToolTipManager() {
        this.enterTimer.setRepeats(false);
        this.exitTimer = new Timer(500, new outsideTimerAction());
        this.exitTimer.setRepeats(false);
        this.insideTimer = new Timer(4000, new stillInsideTimerAction());
        this.insideTimer.setRepeats(false);
        this.postTip = KeyStroke.getKeyStroke(112, 2);
        this.postTipAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ToolTipManager.this.tipWindow != null) {
                    ToolTipManager.this.hideTipWindow();
                } else {
                    ToolTipManager.this.hideTipWindow();
                    ToolTipManager.this.enterTimer.stop();
                    ToolTipManager.this.exitTimer.stop();
                    ToolTipManager.this.insideTimer.stop();
                    ToolTipManager.this.insideComponent = (JComponent)actionEvent.getSource();
                    ToolTipManager.this.toolTipText = ToolTipManager.this.insideComponent.getToolTipText();
                    ToolTipManager.this.preferredLocation = new Point(10, ToolTipManager.this.insideComponent.getHeight() + 10);
                    ToolTipManager.this.showTipWindow();
                    if (ToolTipManager.this.focusChangeListener == null) {
                        ToolTipManager.this.focusChangeListener = ToolTipManager.this.createFocusChangeListener();
                    }
                    ToolTipManager.this.insideComponent.addFocusListener(ToolTipManager.this.focusChangeListener);
                }
            }

            public boolean isEnabled() {
                return true;
            }
        };
        this.hideTip = KeyStroke.getKeyStroke(27, 0);
        this.hideTipAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolTipManager.this.hideTipWindow();
                JComponent jComponent = (JComponent)actionEvent.getSource();
                jComponent.removeFocusListener(ToolTipManager.this.focusChangeListener);
                ToolTipManager.this.preferredLocation = null;
            }

            public boolean isEnabled() {
                return true;
            }
        };
    }

    private FocusListener createFocusChangeListener() {
        return new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ToolTipManager.this.hideTipWindow();
                JComponent jComponent = (JComponent)focusEvent.getSource();
                jComponent.removeFocusListener(ToolTipManager.this.focusChangeListener);
            }
        };
    }

    static Frame frameForComponent(Component component) {
        while (!(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    public int getDismissDelay() {
        return this.insideTimer.getInitialDelay();
    }

    private int getHeightAdjust(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2.y >= rectangle.y && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height) {
            return 0;
        }
        return rectangle2.y + rectangle2.height - (rectangle.y + rectangle.height) + 5;
    }

    public int getInitialDelay() {
        return this.enterTimer.getInitialDelay();
    }

    private int getPopupFitHeight(Rectangle rectangle, Component component) {
        if (component != null) {
            Container container = component.getParent();
            while (container != null) {
                if (container instanceof JFrame || container instanceof JDialog || container instanceof JWindow) {
                    return this.getHeightAdjust(container.getBounds(), rectangle);
                }
                if (container instanceof JApplet || container instanceof JInternalFrame) {
                    if (this.popupFrameRect == null) {
                        this.popupFrameRect = new Rectangle();
                    }
                    Point point = container.getLocationOnScreen();
                    this.popupFrameRect.setBounds(point.x, point.y, container.getBounds().width, container.getBounds().height);
                    return this.getHeightAdjust(this.popupFrameRect, rectangle);
                }
                container = container.getParent();
            }
        }
        return 0;
    }

    private int getPopupFitWidth(Rectangle rectangle, Component component) {
        if (component != null) {
            Container container = component.getParent();
            while (container != null) {
                if (container instanceof JFrame || container instanceof JDialog || container instanceof JWindow) {
                    return this.getWidthAdjust(container.getBounds(), rectangle);
                }
                if (container instanceof JApplet || container instanceof JInternalFrame) {
                    if (this.popupFrameRect == null) {
                        this.popupFrameRect = new Rectangle();
                    }
                    Point point = container.getLocationOnScreen();
                    this.popupFrameRect.setBounds(point.x, point.y, container.getBounds().width, container.getBounds().height);
                    return this.getWidthAdjust(this.popupFrameRect, rectangle);
                }
                container = container.getParent();
            }
        }
        return 0;
    }

    public int getReshowDelay() {
        return this.exitTimer.getInitialDelay();
    }

    private int getWidthAdjust(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2.x >= rectangle.x && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width) {
            return 0;
        }
        return rectangle2.x + rectangle2.width - (rectangle.x + rectangle.width) + 5;
    }

    void hideTipWindow() {
        if (this.tipWindow != null) {
            this.tipWindow.removeMouseListener(this);
            this.tipWindow.hide();
            this.tipWindow = null;
            this.tipShowing = false;
            this.timerEnter = 0L;
            this.tip.getUI().uninstallUI(this.tip);
            this.tip = null;
            this.insideTimer.stop();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.tipShowing && !this.lightWeightPopupEnabled && System.currentTimeMillis() - this.timerEnter < 200L) {
            return;
        }
        if (mouseEvent.getSource() == this.tipWindow) {
            return;
        }
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        this.toolTipText = jComponent.getToolTipText(mouseEvent);
        this.preferredLocation = jComponent.getToolTipLocation(mouseEvent);
        this.exitTimer.stop();
        Point point = mouseEvent.getPoint();
        if (point.x < 0 || point.x >= jComponent.getWidth() || point.y < 0 || point.y >= jComponent.getHeight()) {
            return;
        }
        if (this.insideComponent != null) {
            this.enterTimer.stop();
            this.insideComponent = null;
        }
        jComponent.addMouseMotionListener(this);
        this.insideComponent = jComponent;
        if (this.tipWindow != null) {
            if (this.heavyWeightPopupEnabled) {
                return;
            }
            this.mouseEvent = mouseEvent;
            if (this.showImmediately) {
                this.showTipWindow();
            } else {
                this.enterTimer.start();
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.tipShowing && !this.lightWeightPopupEnabled && System.currentTimeMillis() - this.timerEnter < 200L) {
            return;
        }
        boolean bl = true;
        if (mouseEvent.getSource() == this.tipWindow) {
            Container container = this.insideComponent.getTopLevelAncestor();
            Rectangle rectangle = this.tipWindow.getBounds();
            Point point = mouseEvent.getPoint();
            point.x += rectangle.x;
            point.y += rectangle.y;
            rectangle = container.getBounds();
            point.x -= rectangle.x;
            point.y -= rectangle.y;
            point = SwingUtilities.convertPoint(null, point, this.insideComponent);
            bl = point.x < 0 || point.x >= this.insideComponent.getWidth() || point.y < 0 || point.y >= this.insideComponent.getHeight();
        } else if (mouseEvent.getSource() == this.insideComponent && this.tipWindow != null) {
            Point point = SwingUtilities.convertPoint(this.insideComponent, mouseEvent.getPoint(), null);
            Rectangle rectangle = this.insideComponent.getTopLevelAncestor().getBounds();
            point.x += rectangle.x;
            point.y += rectangle.y;
            rectangle = this.tipWindow.getBounds();
            bl = point.x < rectangle.x || point.x >= rectangle.x + rectangle.width || point.y < rectangle.y || point.y >= rectangle.y + rectangle.height;
        }
        if (bl) {
            this.enterTimer.stop();
            if (this.insideComponent != null) {
                this.insideComponent.removeMouseMotionListener(this);
            }
            this.insideComponent = null;
            this.toolTipText = null;
            this.mouseEvent = null;
            this.hideTipWindow();
            this.exitTimer.start();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        String string = jComponent.getToolTipText(mouseEvent);
        Point point = jComponent.getToolTipLocation(mouseEvent);
        if (string != null || point != null) {
            this.mouseEvent = mouseEvent;
            if ((string != null && string.equals(this.toolTipText) || string == null) && (point != null && point.equals(this.preferredLocation) || point == null)) {
                if (this.tipWindow != null) {
                    this.insideTimer.restart();
                } else {
                    this.enterTimer.restart();
                }
            } else {
                this.toolTipText = string;
                this.preferredLocation = point;
                if (this.showImmediately) {
                    this.hideTipWindow();
                    this.showTipWindow();
                } else {
                    this.enterTimer.restart();
                }
            }
        } else {
            this.toolTipText = null;
            this.preferredLocation = null;
            this.mouseEvent = null;
            this.hideTipWindow();
            this.enterTimer.stop();
            this.exitTimer.start();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.hideTipWindow();
        this.enterTimer.stop();
        this.showImmediately = false;
    }

    public void registerComponent(JComponent jComponent) {
        jComponent.removeMouseListener(this);
        jComponent.addMouseListener(this);
        jComponent.registerKeyboardAction(this.postTipAction, this.postTip, 0);
        jComponent.registerKeyboardAction(this.hideTipAction, this.hideTip, 0);
    }

    public void setDismissDelay(int n) {
        this.insideTimer.setInitialDelay(n);
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!bl) {
            this.hideTipWindow();
        }
    }

    public void setInitialDelay(int n) {
        this.enterTimer.setInitialDelay(n);
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        this.lightWeightPopupEnabled = bl;
    }

    public void setReshowDelay(int n) {
        this.exitTimer.setInitialDelay(n);
    }

    public static ToolTipManager sharedInstance() {
        return sharedInstance;
    }

    void showTipWindow() {
        if (this.insideComponent == null || !this.insideComponent.isShowing()) {
            return;
        }
        if (this.enabled) {
            Point point = this.insideComponent.getLocationOnScreen();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Point point2 = new Point();
            this.hideTipWindow();
            this.tip = this.insideComponent.createToolTip();
            this.tip.setTipText(this.toolTipText);
            Dimension dimension2 = this.tip.getPreferredSize();
            if (this.insideComponent.getRootPane() == null) {
                this.tipWindow = new WindowPopup(ToolTipManager.frameForComponent(this.insideComponent), this.tip, dimension2);
                this.heavyWeightPopupEnabled = true;
            } else if (this.lightWeightPopupEnabled) {
                this.heavyWeightPopupEnabled = false;
                this.tipWindow = new JPanelPopup(this.tip, dimension2);
            } else {
                this.heavyWeightPopupEnabled = false;
                this.tipWindow = new PanelPopup(this.tip, dimension2);
            }
            this.tipWindow.addMouseListener(this);
            if (this.preferredLocation != null) {
                point2.x = point.x + this.preferredLocation.x;
                point2.y = point.y + this.preferredLocation.y;
            } else {
                point2.x = point.x + this.mouseEvent.getX();
                point2.y = point.y + this.mouseEvent.getY() + 20;
                if (point2.x + dimension2.width > dimension.width) {
                    point2.x -= dimension2.width;
                }
                if (point2.y + dimension2.height > dimension.height) {
                    point2.y -= dimension2.height + 20;
                }
            }
            if (!this.heavyWeightPopupEnabled) {
                if (this.popupRect == null) {
                    this.popupRect = new Rectangle();
                }
                this.popupRect.setBounds(point2.x, point2.y, this.tipWindow.getBounds().width, this.tipWindow.getBounds().height);
                int n = this.getPopupFitHeight(this.popupRect, this.insideComponent);
                int n2 = this.getPopupFitWidth(this.popupRect, this.insideComponent);
                if (n > 0) {
                    point2.y -= n;
                }
                if (n2 > 0) {
                    point2.x -= n2;
                }
            }
            this.tipWindow.show(this.insideComponent, point2.x, point2.y);
            this.insideTimer.start();
            this.timerEnter = System.currentTimeMillis();
            this.tipShowing = true;
        }
    }

    public void unregisterComponent(JComponent jComponent) {
        jComponent.removeMouseListener(this);
        jComponent.unregisterKeyboardAction(this.postTip);
        jComponent.unregisterKeyboardAction(this.hideTip);
    }

    protected class insideTimerAction
    implements ActionListener {
        protected insideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ToolTipManager.this.insideComponent != null && ToolTipManager.this.insideComponent.isShowing()) {
                ToolTipManager.this.showImmediately = true;
                ToolTipManager.this.showTipWindow();
            }
        }
    }

    protected class outsideTimerAction
    implements ActionListener {
        protected outsideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ToolTipManager.this.showImmediately = false;
        }
    }

    protected class stillInsideTimerAction
    implements ActionListener {
        protected stillInsideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ToolTipManager.this.hideTipWindow();
            ToolTipManager.this.enterTimer.stop();
            ToolTipManager.this.showImmediately = false;
        }
    }

    private static interface Popup {
        public void addMouseListener(ToolTipManager var1);

        public Rectangle getBounds();

        public void hide();

        public void removeMouseListener(ToolTipManager var1);

        public void show(JComponent var1, int var2, int var3);
    }

    class JPanelPopup
    extends JPanel
    implements Popup {
        public JPanelPopup(JComponent jComponent, Dimension dimension) {
            this.setLayout(new BorderLayout());
            this.setDoubleBuffered(true);
            this.setOpaque(true);
            this.add((Component)jComponent, "Center");
            this.setSize(dimension);
        }

        public void addMouseListener(ToolTipManager toolTipManager) {
            super.addMouseListener(toolTipManager);
        }

        public Rectangle getBounds() {
            return super.getBounds();
        }

        public void hide() {
            Container container = this.getParent();
            Rectangle rectangle = this.getBounds();
            if (container != null) {
                container.remove(this);
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void removeMouseListener(ToolTipManager toolTipManager) {
            super.removeMouseListener(toolTipManager);
        }

        public void show(JComponent jComponent, int n, int n2) {
            Point point = new Point(n, n2);
            SwingUtilities.convertPointFromScreen(point, jComponent.getRootPane().getLayeredPane());
            this.setBounds(point.x, point.y, this.getSize().width, this.getSize().height);
            jComponent.getRootPane().getLayeredPane().add(this, JLayeredPane.POPUP_LAYER, 0);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }

    class PanelPopup
    extends Panel
    implements Popup {
        public PanelPopup(JComponent jComponent, Dimension dimension) {
            this.setLayout(new BorderLayout());
            this.add((Component)jComponent, "Center");
            this.setSize(dimension);
        }

        public void addMouseListener(ToolTipManager toolTipManager) {
            super.addMouseListener(toolTipManager);
        }

        public Rectangle getBounds() {
            return super.getBounds();
        }

        public void hide() {
            Container container = this.getParent();
            Rectangle rectangle = this.getBounds();
            if (container != null) {
                container.remove(this);
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void removeMouseListener(ToolTipManager toolTipManager) {
            super.removeMouseListener(toolTipManager);
        }

        public void show(JComponent jComponent, int n, int n2) {
            Point point = new Point(n, n2);
            SwingUtilities.convertPointFromScreen(point, jComponent.getRootPane().getLayeredPane());
            jComponent.getRootPane().getLayeredPane().add(this, JLayeredPane.POPUP_LAYER, 0);
            this.setBounds(point.x, point.y, this.getSize().width, this.getSize().height);
        }
    }

    class WindowPopup
    extends Window
    implements Popup {
        boolean firstShow = true;
        JComponent tip;
        Frame frame;

        public WindowPopup(Frame frame, JComponent jComponent, Dimension dimension) {
            super(frame);
            this.tip = jComponent;
            this.frame = frame;
            this.add((Component)jComponent, "Center");
            this.pack();
        }

        public void addMouseListener(ToolTipManager toolTipManager) {
            super.addMouseListener(toolTipManager);
        }

        public Rectangle getBounds() {
            return super.getBounds();
        }

        public void hide() {
            super.hide();
            ((Container)this).removeNotify();
        }

        public void removeMouseListener(ToolTipManager toolTipManager) {
            super.removeMouseListener(toolTipManager);
        }

        public void show(JComponent jComponent, int n, int n2) {
            ((Component)this).setLocation(n, n2);
            ((Component)this).setVisible(true);
            if (this.firstShow) {
                this.hide();
                ((Component)this).setVisible(true);
                this.firstShow = false;
            }
        }
    }
}

