/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Bidi;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StateInvariantError;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.Utilities;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public abstract class AbstractDocument
implements Document,
Serializable {
    private transient int numReaders;
    private transient Thread currWriter;
    private Dictionary documentProperties = null;
    protected EventListenerList listenerList = new EventListenerList();
    private Content data;
    private AttributeContext context;
    private transient BranchElement bidiRoot;
    private static final String BAD_LOCK_STATE = "document lock failure";
    protected static final String BAD_LOCATION = "document location failure";
    public static final String ParagraphElementName = "paragraph";
    public static final String ContentElementName = "content";
    public static final String SectionElementName = "section";
    public static final String BidiElementName = "bidi level";
    public static final String ElementNameAttribute = "$ename";
    static final String I18NProperty = "i18n";
    static final String AsyncLoadPriority = "load priority";
    static /* synthetic */ Class class$javax$swing$event$DocumentListener;
    static /* synthetic */ Class class$javax$swing$event$UndoableEditListener;

    protected AbstractDocument(Content content) {
        this(content, StyleContext.getDefaultStyleContext());
    }

    protected AbstractDocument(Content content, AttributeContext attributeContext) {
        this.data = content;
        this.context = attributeContext;
        this.bidiRoot = new BidiRootElement();
        this.putProperty(I18NProperty, Boolean.FALSE);
        try {
            this.writeLock();
            Element[] elementArray = new Element[]{new BidiElement((Element)this.bidiRoot, 0, 1, 0)};
            this.bidiRoot.replace(0, 0, elementArray);
        }
        finally {
            Object var4_4 = null;
            this.writeUnlock();
        }
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.listenerList.add(class$javax$swing$event$DocumentListener != null ? class$javax$swing$event$DocumentListener : (class$javax$swing$event$DocumentListener = AbstractDocument.class$("javax.swing.event.DocumentListener")), documentListener);
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.add(class$javax$swing$event$UndoableEditListener != null ? class$javax$swing$event$UndoableEditListener : (class$javax$swing$event$UndoableEditListener = AbstractDocument.class$("javax.swing.event.UndoableEditListener")), undoableEditListener);
    }

    private byte[] calculateBidiLevels(int n, int n2) {
        byte[] byArray = new byte[n2 - n];
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            String string;
            Element element = this.getParagraphElement(n4);
            int n5 = element.getStartOffset();
            int n6 = element.getEndOffset();
            try {
                string = this.getText(n5, n6 - n5);
            }
            catch (BadLocationException badLocationException) {
                throw new Error("Internal error: " + badLocationException.toString());
            }
            Bidi bidi = new Bidi(string.toCharArray());
            byte[] byArray2 = bidi.getLevels();
            System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
            n3 += byArray2.length;
            n4 = element.getEndOffset();
        }
        if (n3 != byArray.length) {
            throw new Error("levelsEnd assertion failed.");
        }
        return byArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Element createBranchElement(Element element, AttributeSet attributeSet) {
        return new BranchElement(element, attributeSet);
    }

    protected Element createLeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
        return new LeafElement(element, attributeSet, n, n2);
    }

    public synchronized Position createPosition(int n) throws BadLocationException {
        return this.data.createPosition(n);
    }

    public void dump(PrintStream printStream) {
        Element element = this.getDefaultRootElement();
        if (element instanceof AbstractElement) {
            ((AbstractElement)element).dump(printStream, 0);
        }
        this.bidiRoot.dump(printStream, 0);
    }

    protected void fireChangedUpdate(DocumentEvent documentEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$DocumentListener != null ? class$javax$swing$event$DocumentListener : AbstractDocument.class$("javax.swing.event.DocumentListener"))) {
                ((DocumentListener)objectArray[n + 1]).changedUpdate(documentEvent);
            }
            n -= 2;
        }
    }

    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$DocumentListener != null ? class$javax$swing$event$DocumentListener : AbstractDocument.class$("javax.swing.event.DocumentListener"))) {
                ((DocumentListener)objectArray[n + 1]).insertUpdate(documentEvent);
            }
            n -= 2;
        }
    }

    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$DocumentListener != null ? class$javax$swing$event$DocumentListener : AbstractDocument.class$("javax.swing.event.DocumentListener"))) {
                ((DocumentListener)objectArray[n + 1]).removeUpdate(documentEvent);
            }
            n -= 2;
        }
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent undoableEditEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$UndoableEditListener != null ? class$javax$swing$event$UndoableEditListener : AbstractDocument.class$("javax.swing.event.UndoableEditListener"))) {
                ((UndoableEditListener)objectArray[n + 1]).undoableEditHappened(undoableEditEvent);
            }
            n -= 2;
        }
    }

    public int getAsynchronousLoadPriority() {
        Integer n = (Integer)this.getProperty(AsyncLoadPriority);
        if (n != null) {
            return n;
        }
        return -1;
    }

    protected final AttributeContext getAttributeContext() {
        return this.context;
    }

    public Element getBidiRootElement() {
        return this.bidiRoot;
    }

    protected final Content getContent() {
        return this.data;
    }

    protected final synchronized Thread getCurrentWriter() {
        return this.currWriter;
    }

    public abstract Element getDefaultRootElement();

    public Dictionary getDocumentProperties() {
        if (this.documentProperties == null) {
            this.documentProperties = new Hashtable(2);
        }
        return this.documentProperties;
    }

    public final Position getEndPosition() {
        Position position;
        try {
            position = this.createPosition(this.data.length());
        }
        catch (BadLocationException badLocationException) {
            position = null;
        }
        return position;
    }

    public int getLength() {
        return this.data.length() - 1;
    }

    public abstract Element getParagraphElement(int var1);

    public final Object getProperty(Object object) {
        return this.getDocumentProperties().get(object);
    }

    public Element[] getRootElements() {
        Element[] elementArray = new Element[]{this.getDefaultRootElement(), this.getBidiRootElement()};
        return elementArray;
    }

    public final Position getStartPosition() {
        Position position;
        try {
            position = this.createPosition(0);
        }
        catch (BadLocationException badLocationException) {
            position = null;
        }
        return position;
    }

    public String getText(int n, int n2) throws BadLocationException {
        String string = this.data.getString(n, n2);
        return string;
    }

    public void getText(int n, int n2, Segment segment) throws BadLocationException {
        this.data.getChars(n, n2, segment);
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        block4: {
            if (string == null || string.length() == 0) {
                return;
            }
            try {
                this.writeLock();
                UndoableEdit undoableEdit = this.data.insertString(n, string);
                DefaultDocumentEvent defaultDocumentEvent = new DefaultDocumentEvent(n, string.length(), DocumentEvent.EventType.INSERT);
                if (undoableEdit != null) {
                    defaultDocumentEvent.addEdit(undoableEdit);
                }
                this.insertUpdate(defaultDocumentEvent, attributeSet);
                defaultDocumentEvent.end();
                this.fireInsertUpdate(defaultDocumentEvent);
                if (undoableEdit == null || attributeSet != null && attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) break block4;
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.writeUnlock();
                throw throwable;
            }
        }
        Object var5_6 = null;
        this.writeUnlock();
    }

    protected void insertUpdate(DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        if (this.getProperty(I18NProperty).equals(Boolean.TRUE)) {
            this.updateBidi(defaultDocumentEvent);
        }
    }

    boolean isLeftToRight(int n, int n2) {
        int n3;
        Element element = this.getBidiRootElement();
        Element element2 = element.getElement(n3 = element.getElementIndex(n));
        if (element2.getEndOffset() >= n2) {
            AttributeSet attributeSet = element2.getAttributes();
            return StyleConstants.getBidiLevel(attributeSet) % 2 == 0;
        }
        return true;
    }

    protected void postRemoveUpdate(DefaultDocumentEvent defaultDocumentEvent) {
        if (this.getProperty(I18NProperty).equals(Boolean.TRUE)) {
            this.updateBidi(defaultDocumentEvent);
        }
    }

    public final void putProperty(Object object, Object object2) {
        if (object2 != null) {
            this.getDocumentProperties().put(object, object2);
        } else {
            this.getDocumentProperties().remove(object);
        }
    }

    public final synchronized void readLock() {
        try {
            while (this.currWriter != null) {
                if (this.currWriter == Thread.currentThread()) {
                    return;
                }
                this.wait();
            }
            ++this.numReaders;
        }
        catch (InterruptedException interruptedException) {}
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.listenerList = new EventListenerList();
        this.bidiRoot = new BidiRootElement();
        try {
            this.writeLock();
            Element[] elementArray = new Element[]{new BidiElement((Element)this.bidiRoot, 0, 1, 0)};
            this.bidiRoot.replace(0, 0, elementArray);
        }
        finally {
            Object var3_3 = null;
            this.writeUnlock();
        }
        objectInputStream.registerValidation(new ObjectInputValidation(){

            public void validateObject() {
                try {
                    AbstractDocument.this.writeLock();
                    DefaultDocumentEvent defaultDocumentEvent = new DefaultDocumentEvent(0, AbstractDocument.this.getLength(), DocumentEvent.EventType.INSERT);
                    AbstractDocument.this.updateBidi(defaultDocumentEvent);
                }
                finally {
                    Object var2_2 = null;
                    AbstractDocument.this.writeUnlock();
                }
            }
        }, 0);
    }

    public final synchronized void readUnlock() {
        if (this.currWriter == Thread.currentThread()) {
            return;
        }
        if (this.numReaders <= 0) {
            throw new StateInvariantError(BAD_LOCK_STATE);
        }
        --this.numReaders;
        this.notify();
    }

    public void remove(int n, int n2) throws BadLocationException {
        if (n2 > 0) {
            block6: {
                try {
                    Object object;
                    this.writeLock();
                    DefaultDocumentEvent defaultDocumentEvent = new DefaultDocumentEvent(n, n2, DocumentEvent.EventType.REMOVE);
                    boolean bl = false;
                    if (this.getProperty(I18NProperty).equals(Boolean.TRUE)) {
                        object = this.getDefaultRootElement();
                        while (!object.isLeaf()) {
                            object = object.getElement(object.getElementIndex(n));
                        }
                        bl = Utilities.isComposedTextElement((Element)object);
                    }
                    this.removeUpdate(defaultDocumentEvent);
                    object = this.data.remove(n, n2);
                    if (object != null) {
                        defaultDocumentEvent.addEdit((UndoableEdit)object);
                    }
                    this.postRemoveUpdate(defaultDocumentEvent);
                    defaultDocumentEvent.end();
                    this.fireRemoveUpdate(defaultDocumentEvent);
                    if (object == null || bl) break block6;
                    this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    this.writeUnlock();
                    throw throwable;
                }
            }
            Object var4_6 = null;
            this.writeUnlock();
        }
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.listenerList.remove(class$javax$swing$event$DocumentListener != null ? class$javax$swing$event$DocumentListener : (class$javax$swing$event$DocumentListener = AbstractDocument.class$("javax.swing.event.DocumentListener")), documentListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.remove(class$javax$swing$event$UndoableEditListener != null ? class$javax$swing$event$UndoableEditListener : (class$javax$swing$event$UndoableEditListener = AbstractDocument.class$("javax.swing.event.UndoableEditListener")), undoableEditListener);
    }

    protected void removeUpdate(DefaultDocumentEvent defaultDocumentEvent) {
    }

    public void render(Runnable runnable) {
        try {
            this.readLock();
            runnable.run();
        }
        finally {
            Object var3_2 = null;
            this.readUnlock();
        }
    }

    public void setAsynchronousLoadPriority(int n) {
        Integer n2 = n >= 0 ? new Integer(n) : null;
        this.putProperty(AsyncLoadPriority, n2);
    }

    public void setDocumentProperties(Dictionary dictionary) {
        this.documentProperties = dictionary;
    }

    private void updateBidi(DefaultDocumentEvent defaultDocumentEvent) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (defaultDocumentEvent.type == DocumentEvent.EventType.INSERT) {
            int n6 = defaultDocumentEvent.getOffset();
            int n7 = n6 + defaultDocumentEvent.getLength();
            n5 = this.getParagraphElement(n6).getStartOffset();
            n4 = this.getParagraphElement(n7).getEndOffset();
        } else if (defaultDocumentEvent.type == DocumentEvent.EventType.REMOVE) {
            Element element = this.getParagraphElement(defaultDocumentEvent.getOffset());
            n5 = element.getStartOffset();
            n4 = element.getEndOffset();
        } else {
            throw new Error("Internal error: unknown event type.");
        }
        byte[] byArray = this.calculateBidiLevels(n5, n4);
        Vector<BidiElement> vector = new Vector<BidiElement>();
        int n8 = n5;
        int n9 = 0;
        if (n8 > 0) {
            n9 = n3 = this.bidiRoot.getElementIndex(n5 - 1);
            Element element = this.bidiRoot.getElement(n3);
            int n10 = StyleConstants.getBidiLevel(element.getAttributes());
            if (n10 == byArray[0]) {
                n8 = element.getStartOffset();
            } else if (element.getEndOffset() > n5) {
                vector.addElement(new BidiElement((Element)this.bidiRoot, element.getStartOffset(), n5, n10));
            } else {
                ++n9;
            }
        }
        n3 = 0;
        while (n3 < byArray.length && byArray[n3] == byArray[0]) {
            ++n3;
        }
        int n11 = n4;
        BidiElement bidiElement = null;
        int n12 = this.bidiRoot.getElementCount() - 1;
        if (n11 <= this.getLength()) {
            n12 = n2 = this.bidiRoot.getElementIndex(n4);
            Element element = this.bidiRoot.getElement(n2);
            n = StyleConstants.getBidiLevel(element.getAttributes());
            if (n == byArray[byArray.length - 1]) {
                n11 = element.getEndOffset();
            } else if (element.getStartOffset() < n4) {
                bidiElement = new BidiElement((Element)this.bidiRoot, n4, element.getEndOffset(), n);
            } else {
                --n12;
            }
        }
        n2 = byArray.length;
        while (n2 > n3 && byArray[n2 - 1] == byArray[byArray.length - 1]) {
            --n2;
        }
        if (n3 == n2 && byArray[0] == byArray[byArray.length - 1]) {
            vector.addElement(new BidiElement((Element)this.bidiRoot, n8, n11, (int)byArray[0]));
        } else {
            vector.addElement(new BidiElement((Element)this.bidiRoot, n8, n3 + n5, (int)byArray[0]));
            int n13 = n3;
            while (n13 < n2) {
                n = n13;
                while (n < byArray.length && byArray[n] == byArray[n13]) {
                    ++n;
                }
                vector.addElement(new BidiElement((Element)this.bidiRoot, n5 + n13, n5 + n, (int)byArray[n13]));
                n13 = n;
            }
            vector.addElement(new BidiElement((Element)this.bidiRoot, n2 + n5, n11, (int)byArray[byArray.length - 1]));
        }
        if (bidiElement != null) {
            vector.addElement(bidiElement);
        }
        int n14 = 0;
        if (this.bidiRoot.getElementCount() > 0) {
            n14 = n12 - n9 + 1;
        }
        Element[] elementArray = new Element[n14];
        int n15 = 0;
        while (n15 < n14) {
            elementArray[n15] = this.bidiRoot.getElement(n9 + n15);
            ++n15;
        }
        Object[] objectArray = new Element[vector.size()];
        vector.copyInto(objectArray);
        ElementEdit elementEdit = new ElementEdit(this.bidiRoot, n9, elementArray, (Element[])objectArray);
        defaultDocumentEvent.addEdit(elementEdit);
        this.bidiRoot.replace(n9, elementArray.length, (Element[])objectArray);
    }

    protected final synchronized void writeLock() {
        try {
            while (this.numReaders > 0 || this.currWriter != null) {
                if (Thread.currentThread() == this.currWriter) {
                    throw new IllegalStateException("Attempt to mutate in notification");
                }
                this.wait();
            }
            this.currWriter = Thread.currentThread();
        }
        catch (InterruptedException interruptedException) {}
    }

    protected final synchronized void writeUnlock() {
        this.currWriter = null;
        this.notify();
    }

    public static interface Content {
        public Position createPosition(int var1) throws BadLocationException;

        public void getChars(int var1, int var2, Segment var3) throws BadLocationException;

        public String getString(int var1, int var2) throws BadLocationException;

        public UndoableEdit insertString(int var1, String var2) throws BadLocationException;

        public int length();

        public UndoableEdit remove(int var1, int var2) throws BadLocationException;
    }

    public static interface AttributeContext {
        public AttributeSet addAttribute(AttributeSet var1, Object var2, Object var3);

        public AttributeSet addAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet getEmptySet();

        public void reclaim(AttributeSet var1);

        public AttributeSet removeAttribute(AttributeSet var1, Object var2);

        public AttributeSet removeAttributes(AttributeSet var1, Enumeration var2);

        public AttributeSet removeAttributes(AttributeSet var1, AttributeSet var2);
    }

    public abstract class AbstractElement
    implements Element,
    MutableAttributeSet,
    Serializable,
    TreeNode {
        private Element parent;
        private transient AttributeSet attributes;

        public AbstractElement(Element element, AttributeSet attributeSet) {
            this.attributes = attributeSet != null ? attributeSet.copyAttributes() : AbstractDocument.this.getAttributeContext().getEmptySet();
            this.parent = element;
        }

        public void addAttribute(Object object, Object object2) {
            this.checkForIllegalCast();
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeContext.addAttribute(this.attributes, object, object2);
        }

        public void addAttributes(AttributeSet attributeSet) {
            this.checkForIllegalCast();
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeContext.addAttributes(this.attributes, attributeSet);
        }

        private final void checkForIllegalCast() {
            Thread thread = AbstractDocument.this.getCurrentWriter();
            if (thread == null || thread != Thread.currentThread()) {
                throw new StateInvariantError("Illegal cast to MutableAttributeSet");
            }
        }

        public abstract Enumeration children();

        public boolean containsAttribute(Object object, Object object2) {
            return this.attributes.containsAttribute(object, object2);
        }

        public boolean containsAttributes(AttributeSet attributeSet) {
            return this.attributes.containsAttributes(attributeSet);
        }

        public AttributeSet copyAttributes() {
            return this.attributes.copyAttributes();
        }

        public void dump(PrintStream printStream, int n) {
            Object object;
            Object object2;
            PrintWriter printWriter;
            try {
                printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)printStream, "JavaEsc"), true);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                printWriter = new PrintWriter(printStream, true);
            }
            this.indent(printWriter, n);
            if (this.getName() == null) {
                printWriter.print("<??");
            } else {
                printWriter.print("<" + this.getName());
            }
            if (this.getAttributeCount() > 0) {
                printWriter.println("");
                object2 = this.attributes.getAttributeNames();
                while (object2.hasMoreElements()) {
                    object = object2.nextElement();
                    this.indent(printWriter, n + 1);
                    printWriter.println(String.valueOf(String.valueOf(object)) + "=" + this.getAttribute(object));
                }
                this.indent(printWriter, n);
            }
            printWriter.println(">");
            if (this.isLeaf()) {
                this.indent(printWriter, n + 1);
                printWriter.print("[" + this.getStartOffset() + "," + this.getEndOffset() + "]");
                object2 = AbstractDocument.this.getContent();
                try {
                    object = object2.getString(this.getStartOffset(), this.getEndOffset() - this.getStartOffset());
                    if (((String)object).length() > 40) {
                        object = String.valueOf(((String)object).substring(0, 40)) + "...";
                    }
                    printWriter.println("[" + (String)object + "]");
                }
                catch (BadLocationException badLocationException) {}
            } else {
                int n2 = this.getElementCount();
                int n3 = 0;
                while (n3 < n2) {
                    AbstractElement abstractElement = (AbstractElement)this.getElement(n3);
                    abstractElement.dump(printStream, n + 1);
                    ++n3;
                }
            }
        }

        protected void finalize() throws Throwable {
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            attributeContext.reclaim(this.attributes);
        }

        public abstract boolean getAllowsChildren();

        public Object getAttribute(Object object) {
            Object object2 = this.attributes.getAttribute(object);
            if (object2 == null) {
                AttributeSet attributeSet;
                AttributeSet attributeSet2 = attributeSet = this.parent != null ? this.parent.getAttributes() : null;
                if (attributeSet != null) {
                    object2 = attributeSet.getAttribute(object);
                }
            }
            return object2;
        }

        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        public Enumeration getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        public AttributeSet getAttributes() {
            return this;
        }

        public TreeNode getChildAt(int n) {
            return (TreeNode)((Object)this.getElement(n));
        }

        public int getChildCount() {
            return this.getElementCount();
        }

        public Document getDocument() {
            return AbstractDocument.this;
        }

        public abstract Element getElement(int var1);

        public abstract int getElementCount();

        public abstract int getElementIndex(int var1);

        public abstract int getEndOffset();

        public int getIndex(TreeNode treeNode) {
            int n = this.getChildCount() - 1;
            while (n >= 0) {
                if (this.getChildAt(n) == treeNode) {
                    return n;
                }
                --n;
            }
            return -1;
        }

        public String getName() {
            if (this.attributes.isDefined(AbstractDocument.ElementNameAttribute)) {
                return (String)this.attributes.getAttribute(AbstractDocument.ElementNameAttribute);
            }
            return null;
        }

        public TreeNode getParent() {
            return (TreeNode)((Object)this.getParentElement());
        }

        public Element getParentElement() {
            return this.parent;
        }

        public AttributeSet getResolveParent() {
            AttributeSet attributeSet = this.attributes.getResolveParent();
            if (attributeSet == null && this.parent != null) {
                attributeSet = this.parent.getAttributes();
            }
            return attributeSet;
        }

        public abstract int getStartOffset();

        private final void indent(PrintWriter printWriter, int n) {
            int n2 = 0;
            while (n2 < n) {
                printWriter.print("  ");
                ++n2;
            }
        }

        public boolean isDefined(Object object) {
            return this.attributes.isDefined(object);
        }

        public boolean isEqual(AttributeSet attributeSet) {
            return this.attributes.isEqual(attributeSet);
        }

        public abstract boolean isLeaf();

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleContext.readAttributeSet(objectInputStream, simpleAttributeSet);
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeContext.addAttributes(SimpleAttributeSet.EMPTY, simpleAttributeSet);
        }

        public void removeAttribute(Object object) {
            this.checkForIllegalCast();
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeContext.removeAttribute(this.attributes, object);
        }

        public void removeAttributes(Enumeration enumeration) {
            this.checkForIllegalCast();
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeContext.removeAttributes(this.attributes, enumeration);
        }

        public void removeAttributes(AttributeSet attributeSet) {
            this.checkForIllegalCast();
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeSet == this ? attributeContext.getEmptySet() : attributeContext.removeAttributes(this.attributes, attributeSet);
        }

        public void setResolveParent(AttributeSet attributeSet) {
            this.checkForIllegalCast();
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeSet != null ? attributeContext.addAttribute(this.attributes, StyleConstants.ResolveAttribute, attributeSet) : attributeContext.removeAttribute(this.attributes, StyleConstants.ResolveAttribute);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            StyleContext.writeAttributeSet(objectOutputStream, this.attributes);
        }
    }

    public class BranchElement
    extends AbstractElement {
        private AbstractElement[] children = new AbstractElement[1];
        private int nchildren = 0;
        private int lastIndex = -1;

        public BranchElement(Element element, AttributeSet attributeSet) {
            super(element, attributeSet);
        }

        public Enumeration children() {
            if (this.nchildren == 0) {
                return null;
            }
            Vector<AbstractElement> vector = new Vector<AbstractElement>(this.nchildren);
            int n = 0;
            while (n < this.nchildren) {
                vector.addElement(this.children[n]);
                ++n;
            }
            return vector.elements();
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public Element getElement(int n) {
            if (n < this.nchildren) {
                return this.children[n];
            }
            return null;
        }

        public int getElementCount() {
            return this.nchildren;
        }

        public int getElementIndex(int n) {
            int n2;
            AbstractElement abstractElement;
            int n3 = 0;
            int n4 = this.nchildren - 1;
            int n5 = 0;
            int n6 = this.getStartOffset();
            if (this.nchildren == 0) {
                return 0;
            }
            if (n >= this.getEndOffset()) {
                return this.nchildren - 1;
            }
            if (this.lastIndex >= n3 && this.lastIndex <= n4) {
                abstractElement = this.children[this.lastIndex];
                n6 = abstractElement.getStartOffset();
                n2 = abstractElement.getEndOffset();
                if (n >= n6 && n < n2) {
                    return this.lastIndex;
                }
                if (n < n6) {
                    n4 = this.lastIndex;
                } else {
                    n3 = this.lastIndex;
                }
            }
            while (n3 <= n4) {
                n5 = n3 + (n4 - n3) / 2;
                abstractElement = this.children[n5];
                n6 = abstractElement.getStartOffset();
                n2 = abstractElement.getEndOffset();
                if (n >= n6 && n < n2) {
                    int n7;
                    this.lastIndex = n7 = n5;
                    return n7;
                }
                if (n < n6) {
                    n4 = n5 - 1;
                    continue;
                }
                n3 = n5 + 1;
            }
            int n8 = n < n6 ? n5 : n5 + 1;
            this.lastIndex = n8;
            return n8;
        }

        public int getEndOffset() {
            AbstractElement abstractElement = this.children[this.nchildren - 1];
            return abstractElement.getEndOffset();
        }

        public String getName() {
            String string = super.getName();
            if (string == null) {
                string = AbstractDocument.ParagraphElementName;
            }
            return string;
        }

        public int getStartOffset() {
            return this.children[0].getStartOffset();
        }

        public boolean isLeaf() {
            return false;
        }

        public Element positionToElement(int n) {
            int n2 = this.getElementIndex(n);
            AbstractElement abstractElement = this.children[n2];
            int n3 = abstractElement.getStartOffset();
            int n4 = abstractElement.getEndOffset();
            if (n >= n3 && n < n4) {
                return abstractElement;
            }
            return null;
        }

        public void replace(int n, int n2, Element[] elementArray) {
            int n3 = elementArray.length - n2;
            int n4 = n + n2;
            int n5 = this.nchildren - n4;
            int n6 = n4 + n3;
            if (this.nchildren + n3 >= this.children.length) {
                int n7 = Math.max(2 * this.children.length, this.nchildren + n3);
                AbstractElement[] abstractElementArray = new AbstractElement[n7];
                System.arraycopy(this.children, 0, abstractElementArray, 0, n);
                System.arraycopy(elementArray, 0, abstractElementArray, n, elementArray.length);
                System.arraycopy(this.children, n4, abstractElementArray, n6, n5);
                this.children = abstractElementArray;
            } else {
                System.arraycopy(this.children, n4, this.children, n6, n5);
                System.arraycopy(elementArray, 0, this.children, n, elementArray.length);
            }
            this.nchildren += n3;
        }

        public String toString() {
            return "BranchElement(" + this.getName() + ") " + this.getStartOffset() + "," + this.getEndOffset() + "\n";
        }
    }

    public class LeafElement
    extends AbstractElement {
        private transient Position p0;
        private transient Position p1;

        public LeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
            super(element, attributeSet);
            try {
                this.p0 = AbstractDocument.this.createPosition(n);
                this.p1 = AbstractDocument.this.createPosition(n2);
            }
            catch (BadLocationException badLocationException) {
                this.p0 = null;
                this.p1 = null;
                throw new StateInvariantError("Can't create Position references");
            }
        }

        public Enumeration children() {
            return null;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public Element getElement(int n) {
            return null;
        }

        public int getElementCount() {
            return 0;
        }

        public int getElementIndex(int n) {
            return -1;
        }

        public int getEndOffset() {
            return this.p1.getOffset();
        }

        public String getName() {
            String string = super.getName();
            if (string == null) {
                string = AbstractDocument.ContentElementName;
            }
            return string;
        }

        public int getStartOffset() {
            return this.p0.getOffset();
        }

        public boolean isLeaf() {
            return true;
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            int n = objectInputStream.readInt();
            int n2 = objectInputStream.readInt();
            try {
                this.p0 = AbstractDocument.this.createPosition(n);
                this.p1 = AbstractDocument.this.createPosition(n2);
            }
            catch (BadLocationException badLocationException) {
                this.p0 = null;
                this.p1 = null;
                throw new IOException("Can't restore Position references");
            }
        }

        public String toString() {
            return "LeafElement(" + this.getName() + ") " + this.p0 + "," + this.p1 + "\n";
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeInt(this.p0.getOffset());
            objectOutputStream.writeInt(this.p1.getOffset());
        }
    }

    class BidiRootElement
    extends BranchElement {
        BidiRootElement() {
            super(null, null);
        }

        public String getName() {
            return "bidi root";
        }
    }

    class BidiElement
    extends LeafElement {
        BidiElement(Element element, int n, int n2, int n3) {
            super(element, new SimpleAttributeSet(), n, n2);
            this.addAttribute(StyleConstants.BidiLevel, new Integer(n3));
        }

        int getLevel() {
            Integer n = (Integer)this.getAttribute(StyleConstants.BidiLevel);
            if (n != null) {
                return n;
            }
            return 0;
        }

        public String getName() {
            return AbstractDocument.BidiElementName;
        }

        boolean isLeftToRight() {
            return this.getLevel() % 2 == 0;
        }
    }

    public class DefaultDocumentEvent
    extends CompoundEdit
    implements DocumentEvent {
        private int offset;
        private int length;
        private Hashtable changeLookup;
        private DocumentEvent.EventType type;

        public DefaultDocumentEvent(int n, int n2, DocumentEvent.EventType eventType) {
            this.offset = n;
            this.length = n2;
            this.type = eventType;
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (this.changeLookup == null && this.edits.size() > 10) {
                this.changeLookup = new Hashtable();
                int n = this.edits.size();
                int n2 = 0;
                while (n2 < n) {
                    Object e = this.edits.elementAt(n2);
                    if (e instanceof DocumentEvent.ElementChange) {
                        DocumentEvent.ElementChange elementChange = (DocumentEvent.ElementChange)e;
                        this.changeLookup.put(elementChange.getElement(), elementChange);
                    }
                    ++n2;
                }
            }
            if (this.changeLookup != null && undoableEdit instanceof DocumentEvent.ElementChange) {
                DocumentEvent.ElementChange elementChange = (DocumentEvent.ElementChange)((Object)undoableEdit);
                this.changeLookup.put(elementChange.getElement(), elementChange);
            }
            return super.addEdit(undoableEdit);
        }

        public DocumentEvent.ElementChange getChange(Element element) {
            if (this.changeLookup != null) {
                return (DocumentEvent.ElementChange)this.changeLookup.get(element);
            }
            int n = this.edits.size();
            int n2 = 0;
            while (n2 < n) {
                DocumentEvent.ElementChange elementChange;
                Object e = this.edits.elementAt(n2);
                if (e instanceof DocumentEvent.ElementChange && (elementChange = (DocumentEvent.ElementChange)e).getElement() == element) {
                    return elementChange;
                }
                ++n2;
            }
            return null;
        }

        public Document getDocument() {
            return AbstractDocument.this;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public String getPresentationName() {
            DocumentEvent.EventType eventType = this.getType();
            if (eventType == DocumentEvent.EventType.INSERT) {
                return "addition";
            }
            if (eventType == DocumentEvent.EventType.REMOVE) {
                return "deletion";
            }
            return "style change";
        }

        public String getRedoPresentationName() {
            return "Redo " + this.getPresentationName();
        }

        public DocumentEvent.EventType getType() {
            return this.type;
        }

        public String getUndoPresentationName() {
            return "Undo " + this.getPresentationName();
        }

        public boolean isSignificant() {
            return true;
        }

        public void redo() throws CannotRedoException {
            block4: {
                AbstractDocument.this.writeLock();
                try {
                    super.redo();
                    if (this.type == DocumentEvent.EventType.INSERT) {
                        AbstractDocument.this.fireInsertUpdate(this);
                        break block4;
                    }
                    if (this.type == DocumentEvent.EventType.REMOVE) {
                        AbstractDocument.this.fireRemoveUpdate(this);
                        break block4;
                    }
                    AbstractDocument.this.fireChangedUpdate(this);
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    AbstractDocument.this.writeUnlock();
                    throw throwable;
                }
            }
            Object var2_1 = null;
            AbstractDocument.this.writeUnlock();
        }

        public String toString() {
            return this.edits.toString();
        }

        public void undo() throws CannotUndoException {
            block4: {
                AbstractDocument.this.writeLock();
                try {
                    super.undo();
                    if (this.type == DocumentEvent.EventType.REMOVE) {
                        AbstractDocument.this.fireInsertUpdate(this);
                        break block4;
                    }
                    if (this.type == DocumentEvent.EventType.INSERT) {
                        AbstractDocument.this.fireRemoveUpdate(this);
                        break block4;
                    }
                    AbstractDocument.this.fireChangedUpdate(this);
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    AbstractDocument.this.writeUnlock();
                    throw throwable;
                }
            }
            Object var2_1 = null;
            AbstractDocument.this.writeUnlock();
        }
    }

    public static class ElementEdit
    extends AbstractUndoableEdit
    implements DocumentEvent.ElementChange {
        private Element e;
        private int index;
        private Element[] removed;
        private Element[] added;

        public ElementEdit(Element element, int n, Element[] elementArray, Element[] elementArray2) {
            this.e = element;
            this.index = n;
            this.removed = elementArray;
            this.added = elementArray2;
        }

        public Element[] getChildrenAdded() {
            return this.added;
        }

        public Element[] getChildrenRemoved() {
            return this.removed;
        }

        public Element getElement() {
            return this.e;
        }

        public int getIndex() {
            return this.index;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            Element[] elementArray = this.removed;
            this.removed = this.added;
            this.added = elementArray;
            ((BranchElement)this.e).replace(this.index, this.removed.length, this.added);
        }

        public void undo() throws CannotUndoException {
            super.undo();
            ((BranchElement)this.e).replace(this.index, this.added.length, this.removed);
            Element[] elementArray = this.removed;
            this.removed = this.added;
            this.added = elementArray;
        }
    }
}

